/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.user.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.UserAuthDetails;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.user.cache.UserAuthDetailsCache;

@Service
public class DefaultUserAuthDetailsCache
implements UserAuthDetailsCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserAuthDetailsCache.class);
    private final UserService userService;
    @Value(value="${cache.userAuthDetails.maxSize:1000}")
    private int cacheMaxSize;
    @Value(value="${cache.userAuthDetails.timeToLiveInMinutes:30}")
    private int cacheValueTtl;
    private Cache<UserId, UserAuthDetails> cache;

    @PostConstruct
    private void init() {
        this.cache = Caffeine.newBuilder().maximumSize((long)this.cacheMaxSize).expireAfterAccess((long)this.cacheValueTtl, TimeUnit.MINUTES).build();
    }

    @EventListener(value={ComponentLifecycleMsg.class})
    public void onComponentLifecycleEvent(ComponentLifecycleMsg event) {
        if (event.getEntityId() != null && event.getEntityId().getEntityType() == EntityType.USER) {
            this.evict(new UserId(event.getEntityId().getId()));
        }
    }

    public UserAuthDetails getUserAuthDetails(TenantId tenantId, UserId userId) {
        log.trace("Retrieving user with enabled credentials status for id {} for tenant {} from cache", (Object)userId, (Object)tenantId);
        return (UserAuthDetails)this.cache.get((Object)userId, id -> this.userService.findUserAuthDetailsByUserId(tenantId, id));
    }

    public void evict(UserId userId) {
        this.cache.invalidate((Object)userId);
        log.trace("Evicted record for user {} from cache", (Object)userId);
    }

    @ConstructorProperties(value={"userService"})
    @Generated
    public DefaultUserAuthDetailsCache(UserService userService) {
        this.userService = userService;
    }
}

