/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.kafka.KafkaAdmin;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ttl.AbstractCleanUpService;

@Service
@TbCoreComponent
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka' && ${edges.enabled:true} && ${sql.ttl.edge_events.edge_events_ttl:0} > 0")
public class KafkaEdgeTopicsCleanUpService
extends AbstractCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaEdgeTopicsCleanUpService.class);
    private final TopicService topicService;
    private final TenantService tenantService;
    private final EdgeService edgeService;
    private final AttributesService attributesService;
    private final KafkaAdmin kafkaAdmin;
    @Value(value="${sql.ttl.edge_events.edge_events_ttl:2628000}")
    private long ttlSeconds;
    @Value(value="${queue.edge.event-notifications-topic:tb_edge_event.notifications}")
    private String tbEdgeEventNotificationsTopic;

    public KafkaEdgeTopicsCleanUpService(PartitionService partitionService, EdgeService edgeService, TenantService tenantService, AttributesService attributesService, TopicService topicService, KafkaAdmin kafkaAdmin) {
        super(partitionService);
        this.topicService = topicService;
        this.tenantService = tenantService;
        this.edgeService = edgeService;
        this.attributesService = attributesService;
        this.kafkaAdmin = kafkaAdmin;
    }

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.edge_events.execution_interval_ms})}", fixedDelayString="${sql.ttl.edge_events.execution_interval_ms}")
    public void cleanUp() {
        if (!this.isSystemTenantPartitionMine()) {
            return;
        }
        Set topics = this.kafkaAdmin.listTopics();
        if (topics.isEmpty()) {
            return;
        }
        String edgeTopicPrefix = this.topicService.buildTopicName(this.tbEdgeEventNotificationsTopic);
        List<String> matchingTopics = topics.stream().filter(topic -> topic.startsWith(edgeTopicPrefix)).toList();
        if (matchingTopics.isEmpty()) {
            log.debug("No matching topics found with prefix [{}]. Skipping cleanup.", (Object)edgeTopicPrefix);
            return;
        }
        Map tenantEdgeMap = this.extractTenantAndEdgeIds(matchingTopics, edgeTopicPrefix);
        long currentTimeMillis = System.currentTimeMillis();
        long ttlMillis = TimeUnit.SECONDS.toMillis(this.ttlSeconds);
        tenantEdgeMap.forEach((tenantId, edgeIds) -> this.processTenantCleanUp(tenantId, edgeIds, ttlMillis, currentTimeMillis));
    }

    private void processTenantCleanUp(TenantId tenantId, List<EdgeId> edgeIds, long ttlMillis, long currentTimeMillis) {
        boolean tenantExists = this.tenantService.tenantExists(tenantId);
        if (tenantExists) {
            for (EdgeId edgeId : edgeIds) {
                try {
                    ((Optional)this.attributesService.find(tenantId, (EntityId)edgeId, AttributeScope.SERVER_SCOPE, "lastConnectTime").get()).flatMap(KvEntry::getLongValue).filter(lastConnectTime -> this.isTopicExpired(lastConnectTime.longValue(), ttlMillis, currentTimeMillis)).ifPresentOrElse(lastConnectTime -> {
                        String topic = this.topicService.buildEdgeEventNotificationsTopicPartitionInfo(tenantId, edgeId).getTopic();
                        if (this.kafkaAdmin.isTopicEmpty(topic)) {
                            this.deleteTopicAndConsumerGroup(topic);
                            log.info("[{}] Removed outdated topic {} for edge {} older than {}", new Object[]{tenantId, topic, edgeId, Date.from(Instant.ofEpochMilli(currentTimeMillis - ttlMillis))});
                        }
                    }, () -> {
                        Edge edge = this.edgeService.findEdgeById(tenantId, edgeId);
                        if (edge == null) {
                            String topic = this.topicService.buildEdgeEventNotificationsTopicPartitionInfo(tenantId, edgeId).getTopic();
                            this.deleteTopicAndConsumerGroup(topic);
                            log.info("[{}] Removed topic {} for deleted edge {}", new Object[]{tenantId, topic, edgeId});
                        }
                    });
                }
                catch (Exception e) {
                    log.error("[{}] Failed to delete topic for edge {}", new Object[]{tenantId, edgeId, e});
                }
            }
        } else {
            for (EdgeId edgeId : edgeIds) {
                String topic = this.topicService.buildEdgeEventNotificationsTopicPartitionInfo(tenantId, edgeId).getTopic();
                this.deleteTopicAndConsumerGroup(topic);
            }
            log.info("[{}] Removed topics for not existing tenant and edges {}", (Object)tenantId, edgeIds);
        }
    }

    private void deleteTopicAndConsumerGroup(String topic) {
        this.kafkaAdmin.deleteTopic(topic);
        this.kafkaAdmin.deleteConsumerGroup(topic);
    }

    private boolean isTopicExpired(long lastConnectTime, long ttlMillis, long currentTimeMillis) {
        return lastConnectTime + ttlMillis < currentTimeMillis;
    }

    private Map<TenantId, List<EdgeId>> extractTenantAndEdgeIds(List<String> topics, String prefix) {
        HashMap<TenantId, List<EdgeId>> tenantEdgeMap = new HashMap<TenantId, List<EdgeId>>();
        for (String topic : topics) {
            try {
                String remaining = topic.substring(prefix.length() + 1);
                String[] parts = remaining.split("\\.");
                TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString(parts[0]));
                EdgeId edgeId = new EdgeId(UUID.fromString(parts[1]));
                tenantEdgeMap.computeIfAbsent(tenantId, id -> new ArrayList()).add(edgeId);
            }
            catch (Exception e) {
                log.warn("Failed to extract TenantId and EdgeId from topic [{}]", (Object)topic, (Object)e);
            }
        }
        return tenantEdgeMap;
    }
}

