/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.audit.AuditLogDao;
import org.thingsboard.server.dao.sqlts.insert.sql.SqlPartitioningRepository;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.service.ttl.AbstractCleanUpService;

@Service
@ConditionalOnExpression(value="${sql.ttl.audit_logs.enabled:true} && ${sql.ttl.audit_logs.ttl:0} > 0")
public class AuditLogsCleanUpService
extends AbstractCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditLogsCleanUpService.class);
    private final AuditLogDao auditLogDao;
    private final SqlPartitioningRepository partitioningRepository;
    @Value(value="${sql.ttl.audit_logs.ttl:0}")
    private long ttlInSec;
    @Value(value="${sql.audit_logs.partition_size:168}")
    private int partitionSizeInHours;

    public AuditLogsCleanUpService(PartitionService partitionService, AuditLogDao auditLogDao, SqlPartitioningRepository partitioningRepository) {
        super(partitionService);
        this.auditLogDao = auditLogDao;
        this.partitioningRepository = partitioningRepository;
    }

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.audit_logs.checking_interval_ms})}", fixedDelayString="${sql.ttl.audit_logs.checking_interval_ms}")
    public void cleanUp() {
        long auditLogsExpTime = this.getCurrentTimeMillis() - TimeUnit.SECONDS.toMillis(this.ttlInSec);
        log.debug("cleanup {}", (Object)auditLogsExpTime);
        if (this.isSystemTenantPartitionMine()) {
            this.auditLogDao.cleanUpAuditLogs(auditLogsExpTime);
        } else {
            this.partitioningRepository.cleanupPartitionsCache("audit_log", auditLogsExpTime, TimeUnit.HOURS.toMillis(this.partitionSizeInHours));
        }
    }

    public long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

