/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.pat.ApiKeyDao;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ttl.AbstractCleanUpService;

@Service
@TbCoreComponent
@ConditionalOnExpression(value="${sql.ttl.api_keys.enabled:true} && ${sql.ttl.api_keys.ttl:0} > 0")
public class ApiKeysCleanUpService
extends AbstractCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiKeysCleanUpService.class);
    public static final String RANDOM_DELAY_INTERVAL_MS_EXPRESSION = "#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.api_keys.checking_interval_ms})}";
    private final ApiKeyDao apiKeyDao;

    public ApiKeysCleanUpService(PartitionService partitionService, ApiKeyDao apiKeyDao) {
        super(partitionService);
        this.apiKeyDao = apiKeyDao;
    }

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.api_keys.checking_interval_ms})}", fixedDelayString="${sql.ttl.api_keys.checking_interval_ms:86400000}")
    public void cleanUp() {
        int deleted;
        long threshold = System.currentTimeMillis();
        if (this.isSystemTenantPartitionMine() && (deleted = this.apiKeyDao.deleteAllByExpirationTimeBefore(threshold)) > 0) {
            log.info("API key cleanup removed {} keys (thresholdTs={})", (Object)deleted, (Object)threshold);
        }
    }
}

