/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.trendz;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.pat.ApiKey;
import org.thingsboard.server.common.data.pat.ApiKeyInfo;
import org.thingsboard.server.common.data.permission.AuthorityPermissionsInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.trendz.TrendzConfiguration;
import org.thingsboard.server.common.data.trendz.TrendzHealthcheckResult;
import org.thingsboard.server.common.data.trendz.TrendzSettings;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationResult;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationResultType;
import org.thingsboard.server.common.data.trendz.TrendzSynchronizationStatus;
import org.thingsboard.server.dao.pat.ApiKeyService;
import org.thingsboard.server.dao.trendz.TrendzSettingsService;
import org.thingsboard.server.dao.trendz.TrendzSyncService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.security.system.SystemSecurityService;
import org.thingsboard.server.service.trendz.DefaultTrendzSyncService;
import org.thingsboard.server.service.trendz.TrendzClient;

@Service
public class DefaultTrendzSyncService
implements TrendzSyncService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTrendzSyncService.class);
    private static final String MIN_SUPPORTED_VERSION = "1.15.0";
    private final ApiKeyService apiKeyService;
    private final UserService userService;
    private final TrendzSettingsService trendzSettingsService;
    private final SystemSecurityService systemSecurityService;
    private final TrendzClient trendzClient;
    @Value(value="${trendz.enabled:true}")
    private boolean trendzEnabled;
    @Value(value="${trendz.default_tb_url:}")
    private String defaultTbUrl;
    @Value(value="${trendz.default_trendz_url:}")
    private String defaultTrendzUrl;

    public synchronized TrendzSettings performSync() {
        log.trace("Executing performSync");
        if (!this.trendzEnabled) {
            return this.saveTrendzSettings(null, null, null, 0L, TrendzSynchronizationResultType.SYNC_DISABLED, TrendzSynchronizationStatus.NOT_AVAILABLE);
        }
        TrendzSettings trendzSettings = this.trendzSettingsService.findTrendzSettings();
        if (!this.isValidTrendzConfiguration(trendzSettings)) {
            trendzSettings = this.createDefaultTrendzSettings(trendzSettings);
        }
        String tbUrl = trendzSettings.configuration().tbUrl();
        String trendzUrl = trendzSettings.configuration().trendzUrl();
        if (tbUrl == null || trendzUrl == null) {
            return this.saveTrendzSettings(trendzUrl, tbUrl, null, 0L, TrendzSynchronizationResultType.SYNC_NOT_INITIALIZED, TrendzSynchronizationStatus.NOT_AVAILABLE);
        }
        log.trace("Starting Trendz synchronization. Trendz URL: {}, TB URL: {}", (Object)trendzUrl, (Object)tbUrl);
        long updatedTs = System.currentTimeMillis();
        ApiKey trendzApiKey = this.findOrCreateTrendzApiKey();
        TrendzInfo trendzInfo = this.validateTrendzConnectionInfo(trendzUrl, tbUrl, updatedTs);
        if (trendzInfo == null) {
            log.debug("Trendz validation failed, sync result is already in settings");
            return this.trendzSettingsService.findTrendzSettings();
        }
        String trendzVersion = trendzInfo.version();
        String externalTbUrl = this.systemSecurityService.getBaseUrl(TenantId.SYS_TENANT_ID, null, null);
        TrendzHealthcheckResult syncResult = this.trendzClient.processTrendzInitRequest(trendzUrl, tbUrl, externalTbUrl != null ? externalTbUrl : tbUrl, trendzApiKey.getValue(), null);
        if (syncResult == null) {
            log.debug("Failed to initiate synchronization with Trendz");
            return this.saveTrendzSettings(trendzUrl, tbUrl, trendzVersion, updatedTs, TrendzSynchronizationResultType.SYNC_INTERNAL_ERROR, TrendzSynchronizationStatus.AVAILABLE);
        }
        TrendzSettings settings = this.saveTrendzSettings(trendzUrl, tbUrl, syncResult.version(), updatedTs, syncResult.type(), syncResult.status());
        if (syncResult.type() != TrendzSynchronizationResultType.SYNC_COMPLETED) {
            log.debug("Trendz sync failed. Status: {}, Message: {}", (Object)syncResult.type(), (Object)syncResult.message());
        }
        log.info("Trendz synchronization completed. Status: {}, Result: {}", (Object)settings.synchronizationResult().status(), (Object)settings.synchronizationResult().type());
        return settings;
    }

    public void performSyncIfNeeded() {
        TrendzSettings trendzSettings = this.trendzSettingsService.findTrendzSettings();
        if (this.isSyncedUp(trendzSettings)) {
            log.trace("Trendz is already synced up. Status: {}, Result: {}", (Object)trendzSettings.synchronizationResult().status(), (Object)trendzSettings.synchronizationResult().type());
        } else {
            this.performSync();
        }
    }

    public TrendzHealthcheckResult performHealthcheck() {
        TrendzInfo trendzInfo;
        log.trace("Executing performHealthcheck");
        if (!this.trendzEnabled) {
            return new TrendzHealthcheckResult(null, TrendzSynchronizationResultType.SYNC_DISABLED, TrendzSynchronizationStatus.NOT_AVAILABLE, TrendzSynchronizationResultType.SYNC_DISABLED.getMessage());
        }
        TrendzSettings trendzSettings = this.trendzSettingsService.findTrendzSettings();
        if (!this.isSyncedUp(trendzSettings)) {
            return new TrendzHealthcheckResult(null, TrendzSynchronizationResultType.SYNC_NOT_INITIALIZED, TrendzSynchronizationStatus.NOT_AVAILABLE, TrendzSynchronizationResultType.SYNC_NOT_INITIALIZED.getMessage());
        }
        String trendzUrl = trendzSettings.configuration().trendzUrl();
        JsonNode rawResponse = this.trendzClient.checkTrendzReachability(trendzUrl);
        if (rawResponse == null) {
            return new TrendzHealthcheckResult(trendzSettings.synchronizationResult().version(), TrendzSynchronizationResultType.TRENDZ_URL_UNREACHABLE, TrendzSynchronizationStatus.NOT_AVAILABLE, TrendzSynchronizationResultType.TRENDZ_URL_UNREACHABLE.getMessage());
        }
        try {
            trendzInfo = (TrendzInfo)JacksonUtil.convertValue((Object)rawResponse, TrendzInfo.class);
        }
        catch (Exception e) {
            return new TrendzHealthcheckResult(trendzSettings.synchronizationResult().version(), TrendzSynchronizationResultType.SYNC_INTERNAL_ERROR, TrendzSynchronizationStatus.NOT_AVAILABLE, TrendzSynchronizationResultType.SYNC_INTERNAL_ERROR.getMessage());
        }
        if (trendzInfo != null && !this.isVersionSupported(trendzInfo.version())) {
            return new TrendzHealthcheckResult(trendzSettings.synchronizationResult().version(), TrendzSynchronizationResultType.TRENDZ_UNSUPPORTED_VERSION, TrendzSynchronizationStatus.AVAILABLE, TrendzSynchronizationResultType.TRENDZ_UNSUPPORTED_VERSION.getMessage());
        }
        ApiKey trendzApiKey = this.apiKeyService.findInternalApiKeyByDescription(TenantId.SYS_TENANT_ID, "Internal API key used to authenticate with Trendz");
        if (trendzApiKey == null || !trendzApiKey.isInternal()) {
            return new TrendzHealthcheckResult(trendzSettings.synchronizationResult().version(), TrendzSynchronizationResultType.TRENDZ_AUTH_INVALID, TrendzSynchronizationStatus.AVAILABLE, TrendzSynchronizationResultType.TRENDZ_AUTH_INVALID.getMessage());
        }
        return this.trendzClient.sendHealthcheckRequest(trendzUrl, trendzApiKey.getValue());
    }

    public void performApiKeyRotationSync(ApiKey newApiKey, ApiKey oldApiKey) {
        log.trace("Executing performApiKeyRotationSync");
        if (!this.trendzEnabled) {
            return;
        }
        try {
            if (!"Internal API key used to authenticate with Trendz".equals(newApiKey.getDescription()) || !newApiKey.isInternal()) {
                return;
            }
            log.trace("Notifying Trendz about API key rotation. API Key ID: {}", (Object)newApiKey.getId());
            TrendzSettings settings = this.trendzSettingsService.findTrendzSettings();
            if (settings == null || settings.configuration() == null) {
                log.debug("Trendz settings not found, cannot notify about key rotation");
                return;
            }
            String trendzUrl = settings.configuration().trendzUrl();
            String tbUrl = settings.configuration().tbUrl();
            if (StringUtils.isEmpty((String)trendzUrl) || StringUtils.isEmpty((String)tbUrl)) {
                log.debug("Trendz URL or TB URL not configured, cannot notify about key rotation");
                return;
            }
            String externalTbUrl = this.systemSecurityService.getBaseUrl(TenantId.SYS_TENANT_ID, null, null);
            this.trendzClient.processTrendzInitRequest(trendzUrl, tbUrl, externalTbUrl != null ? externalTbUrl : tbUrl, newApiKey.getValue(), oldApiKey != null ? oldApiKey.getValue() : null);
        }
        catch (Exception e) {
            log.debug("Error notifying Trendz about API key rotation", (Throwable)e);
        }
    }

    private boolean isSyncedUp(TrendzSettings settings) {
        return settings != null && settings.synchronizationResult() != null && settings.synchronizationResult().status() != null && settings.synchronizationResult().status() != TrendzSynchronizationStatus.NOT_AVAILABLE;
    }

    private TrendzSettings createDefaultTrendzSettings(TrendzSettings prevVersion) {
        String trendzUrl = prevVersion != null && prevVersion.configuration() != null && prevVersion.configuration().trendzUrl() != null ? prevVersion.configuration().trendzUrl() : (StringUtils.isNotBlank((String)this.defaultTrendzUrl) ? this.defaultTrendzUrl : null);
        String tbUrl = prevVersion != null && prevVersion.configuration() != null && prevVersion.configuration().tbUrl() != null ? prevVersion.configuration().tbUrl() : (StringUtils.isNotBlank((String)this.defaultTbUrl) ? this.defaultTbUrl : null);
        TrendzSettings settings = new TrendzSettings(new TrendzConfiguration(trendzUrl, tbUrl), new TrendzSynchronizationResult(null, Long.valueOf(0L), TrendzSynchronizationResultType.SYNC_NOT_INITIALIZED, TrendzSynchronizationStatus.NOT_AVAILABLE));
        this.trendzSettingsService.saveTrendzSettings(settings);
        return settings;
    }

    private TrendzInfo validateTrendzConnectionInfo(String trendzUrl, String tbUrl, long updatedTs) {
        TrendzInfo trendzInfo;
        JsonNode rawResponse = this.trendzClient.checkTrendzReachability(trendzUrl);
        if (rawResponse == null) {
            this.saveTrendzSettings(trendzUrl, tbUrl, null, updatedTs, TrendzSynchronizationResultType.TRENDZ_URL_UNREACHABLE, TrendzSynchronizationStatus.NOT_AVAILABLE);
            log.debug("Trendz is not reachable at URL: {}", (Object)trendzUrl);
            return null;
        }
        try {
            trendzInfo = (TrendzInfo)JacksonUtil.convertValue((Object)rawResponse, TrendzInfo.class);
        }
        catch (Exception e) {
            this.saveTrendzSettings(trendzUrl, tbUrl, null, updatedTs, TrendzSynchronizationResultType.SYNC_INTERNAL_ERROR, TrendzSynchronizationStatus.NOT_AVAILABLE);
            log.debug("Trendz version info is not recognized from URL: {} - unexpected JSON structure", (Object)trendzUrl, (Object)e);
            return null;
        }
        if (trendzInfo != null && !this.isVersionSupported(trendzInfo.version())) {
            this.saveTrendzSettings(trendzUrl, tbUrl, trendzInfo.version(), updatedTs, TrendzSynchronizationResultType.TRENDZ_UNSUPPORTED_VERSION, TrendzSynchronizationStatus.AVAILABLE);
            log.debug("Trendz version {} is not supported. Minimum required version: {}", (Object)trendzInfo.version(), (Object)MIN_SUPPORTED_VERSION);
            return null;
        }
        return trendzInfo;
    }

    private TrendzSettings createSettings(String trendzUrl, String tbUrl, String trendzVersion, Long updatedTs, TrendzSynchronizationResultType resultType, TrendzSynchronizationStatus status) {
        TrendzConfiguration config = new TrendzConfiguration(trendzUrl, tbUrl);
        TrendzSynchronizationResult syncResult = new TrendzSynchronizationResult(trendzVersion, updatedTs, resultType, status);
        return new TrendzSettings(config, syncResult);
    }

    private boolean isVersionSupported(String version) {
        if (version == null || version.isBlank()) {
            log.debug("Version is null or empty, treating as unsupported");
            return false;
        }
        try {
            String cleanVersion = version.split("-")[0];
            String[] versionParts = cleanVersion.split("\\.");
            String[] minVersionParts = MIN_SUPPORTED_VERSION.split("\\.");
            for (int i = 0; i < Math.min(versionParts.length, minVersionParts.length); ++i) {
                int required;
                int current = Integer.parseInt(versionParts[i]);
                if (current > (required = Integer.parseInt(minVersionParts[i]))) {
                    return true;
                }
                if (current >= required) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse version '{}': Invalid number format in version string", (Object)version, (Object)e);
            return false;
        }
        catch (Exception e) {
            log.warn("Failed to parse version '{}': {}", new Object[]{version, e.getMessage(), e});
            return false;
        }
    }

    private ApiKey findOrCreateTrendzApiKey() {
        PageLink pageLink = new PageLink(1, 0, null, new SortOrder("createdTime", SortOrder.Direction.ASC));
        User sysAdminUser = (User)this.userService.findSysAdmins(pageLink).getData().get(0);
        ApiKey trendzApiKey = this.apiKeyService.findInternalApiKeyByDescription(TenantId.SYS_TENANT_ID, "Internal API key used to authenticate with Trendz");
        if (trendzApiKey != null && trendzApiKey.isInternal()) {
            log.trace("Found existing Trendz API key: {}", (Object)trendzApiKey.getId());
            return trendzApiKey;
        }
        log.trace("Creating new Trendz internal API key with configured permissions");
        ApiKeyInfo apiKeyInfo = new ApiKeyInfo();
        apiKeyInfo.setTenantId(TenantId.SYS_TENANT_ID);
        apiKeyInfo.setUserId(sysAdminUser.getId());
        apiKeyInfo.setDescription("Internal API key used to authenticate with Trendz");
        apiKeyInfo.setEnabled(true);
        apiKeyInfo.setExpirationTime(0L);
        apiKeyInfo.setInternal(true);
        apiKeyInfo.setPermissions(this.buildTrendzPermissions());
        return this.apiKeyService.saveApiKey(TenantId.SYS_TENANT_ID, apiKeyInfo);
    }

    private AuthorityPermissionsInfo buildTrendzPermissions() {
        HashMap permissions = new HashMap();
        HashMap<Resource, Set<Operation>> tenantCustomerPermissions = new HashMap<Resource, Set<Operation>>();
        tenantCustomerPermissions.put(Resource.DEVICE, Set.of(Operation.READ, Operation.READ_ATTRIBUTES, Operation.WRITE_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.WRITE_TELEMETRY));
        tenantCustomerPermissions.put(Resource.ASSET, Set.of(Operation.READ, Operation.READ_ATTRIBUTES, Operation.WRITE_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.WRITE_TELEMETRY));
        tenantCustomerPermissions.put(Resource.ALARM, Set.of(Operation.READ, Operation.CREATE, Operation.WRITE, Operation.DELETE));
        tenantCustomerPermissions.put(Resource.CUSTOMER, Set.of(Operation.READ, Operation.READ_ATTRIBUTES, Operation.WRITE_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.WRITE_TELEMETRY));
        tenantCustomerPermissions.put(Resource.DASHBOARD, Set.of(Operation.READ, Operation.CREATE, Operation.WRITE));
        tenantCustomerPermissions.put(Resource.TENANT, Set.of(Operation.READ));
        tenantCustomerPermissions.put(Resource.USER, Set.of(Operation.READ));
        tenantCustomerPermissions.put(Resource.WHITE_LABELING, Set.of(Operation.READ));
        tenantCustomerPermissions.put(Resource.DEVICE_PROFILE, Set.of(Operation.READ));
        tenantCustomerPermissions.put(Resource.ASSET_PROFILE, Set.of(Operation.READ));
        permissions.put(Authority.TENANT_ADMIN, tenantCustomerPermissions);
        permissions.put(Authority.CUSTOMER_USER, tenantCustomerPermissions);
        HashMap<Resource, Set<Operation>> sysAdminPermissions = new HashMap<Resource, Set<Operation>>();
        sysAdminPermissions.put(Resource.ADMIN_SETTINGS, Set.of(Operation.READ, Operation.WRITE));
        sysAdminPermissions.put(Resource.WIDGETS_BUNDLE, Set.of(Operation.READ, Operation.CREATE, Operation.WRITE, Operation.DELETE));
        sysAdminPermissions.put(Resource.WIDGET_TYPE, Set.of(Operation.READ, Operation.CREATE, Operation.WRITE, Operation.DELETE));
        sysAdminPermissions.put(Resource.TB_RESOURCE, Set.of(Operation.READ, Operation.CREATE, Operation.WRITE, Operation.DELETE));
        permissions.put(Authority.SYS_ADMIN, sysAdminPermissions);
        AuthorityPermissionsInfo permissionsInfo = new AuthorityPermissionsInfo();
        permissionsInfo.setOperationsByResource(permissions);
        return permissionsInfo;
    }

    private TrendzSettings saveTrendzSettings(String trendzUrl, String tbUrl, String version, long updatedTs, TrendzSynchronizationResultType resultType, TrendzSynchronizationStatus status) {
        TrendzSettings settings = this.createSettings(trendzUrl, tbUrl, version, Long.valueOf(updatedTs), resultType, status);
        this.trendzSettingsService.saveTrendzSettings(settings);
        return settings;
    }

    private boolean isValidTrendzConfiguration(TrendzSettings settings) {
        return settings != null && settings.configuration() != null && settings.configuration().tbUrl() != null && settings.configuration().trendzUrl() != null;
    }

    @ConstructorProperties(value={"apiKeyService", "userService", "trendzSettingsService", "systemSecurityService", "trendzClient"})
    @Generated
    public DefaultTrendzSyncService(ApiKeyService apiKeyService, UserService userService, TrendzSettingsService trendzSettingsService, SystemSecurityService systemSecurityService, TrendzClient trendzClient) {
        this.apiKeyService = apiKeyService;
        this.userService = userService;
        this.trendzSettingsService = trendzSettingsService;
        this.systemSecurityService = systemSecurityService;
        this.trendzClient = trendzClient;
    }
}

