/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.trendz;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.trendz.TrendzSummary;
import org.thingsboard.server.common.data.trendz.TrendzUsage;
import org.thingsboard.server.common.data.trendz.TrendzViewConfig;
import org.thingsboard.server.common.data.trendz.TrendzViewConfigLite;
import org.thingsboard.server.dao.trendz.TrendzApiService;
import org.thingsboard.server.service.trendz.TrendzClient;

@Service
public class DefaultTrendzApiService
implements TrendzApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTrendzApiService.class);
    private final TrendzClient trendzClient;

    public TrendzViewConfig getViewById(User user, UUID viewId) throws ThingsboardException {
        return this.trendzClient.getTrendzViewById(viewId, user);
    }

    public PageData<TrendzViewConfigLite> getAllViews(User user, PageLink pageLink) throws ThingsboardException {
        return this.trendzClient.getAllTrendzViews(pageLink, user).toPageData();
    }

    public TrendzSummary getTrendzSummary(User user) throws ThingsboardException {
        return this.trendzClient.getTrendzSummary(user);
    }

    public TrendzUsage getTrendzUsage(User user) throws ThingsboardException {
        return this.trendzClient.getTrendzUsage(user);
    }

    @ConstructorProperties(value={"trendzClient"})
    @Generated
    public DefaultTrendzApiService(TrendzClient trendzClient) {
        this.trendzClient = trendzClient;
    }
}

