/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.transport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.cache.ota.OtaPackageDataCache;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileProvisionType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.device.credentials.BasicMqttCredentials;
import org.thingsboard.server.common.data.device.credentials.ProvisionDeviceCredentialsData;
import org.thingsboard.server.common.data.device.profile.ProvisionDeviceProfileCredentials;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.common.msg.EncryptionUtil;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceProvisionService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.device.provision.ProvisionFailedException;
import org.thingsboard.server.dao.device.provision.ProvisionRequest;
import org.thingsboard.server.dao.device.provision.ProvisionResponse;
import org.thingsboard.server.dao.device.provision.ProvisionResponseStatus;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.exception.EntitiesLimitExceededException;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.transport.BasicCredentialsValidationResult;
import org.thingsboard.server.service.transport.DefaultTransportApiService;
import org.thingsboard.server.service.transport.TransportApiService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@TbCoreComponent
public class DefaultTransportApiService
implements TransportApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTransportApiService.class);
    private static final Pattern X509_CERTIFICATE_TRIM_CHAIN_PATTERN = Pattern.compile("-----BEGIN CERTIFICATE-----\\s*.*?\\s*-----END CERTIFICATE-----");
    private final TbDeviceProfileCache deviceProfileCache;
    private final TbTenantProfileCache tenantProfileCache;
    private final TbApiUsageStateService apiUsageStateService;
    private final DeviceService deviceService;
    private final DeviceProfileService deviceProfileService;
    private final RelationService relationService;
    private final DeviceCredentialsService deviceCredentialsService;
    private final TbClusterService tbClusterService;
    private final DeviceProvisionService deviceProvisionService;
    private final ResourceService resourceService;
    private final OtaPackageService otaPackageService;
    private final OtaPackageDataCache otaPackageDataCache;
    private final QueueService queueService;
    private final EntityGroupService entityGroupService;
    private final CustomerService customerService;
    private final ConcurrentMap<String, ReentrantLock> deviceCreationLocks = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    @Value(value="${queue.transport_api.max_core_handler_threads:16}")
    private int maxCoreHandlerThreads;
    ListeningExecutorService handlerExecutor;

    private static boolean checkIsMqttCredentials(DeviceCredentials credentials) {
        return credentials != null && DeviceCredentialsType.MQTT_BASIC.equals((Object)credentials.getCredentialsType());
    }

    @PostConstruct
    public void init() {
        this.handlerExecutor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)this.maxCoreHandlerThreads, (String)"transport-api-service-core-handler"));
    }

    @PreDestroy
    public void destroy() {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.shutdownNow();
        }
    }

    public ListenableFuture<TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> handle(TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg> tbProtoQueueMsg) {
        TransportProtos.TransportApiRequestMsg transportApiRequestMsg = (TransportProtos.TransportApiRequestMsg)tbProtoQueueMsg.getValue();
        return this.handlerExecutor.submit(() -> {
            TransportProtos.TransportApiResponseMsg result = this.handle(transportApiRequestMsg);
            return new TbProtoQueueMsg(tbProtoQueueMsg.getKey(), (GeneratedMessageV3)result, tbProtoQueueMsg.getHeaders());
        });
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.TransportApiRequestMsg transportApiRequestMsg) {
        if (transportApiRequestMsg.hasValidateTokenRequestMsg()) {
            TransportProtos.ValidateDeviceTokenRequestMsg msg = transportApiRequestMsg.getValidateTokenRequestMsg();
            String token = msg.getToken();
            return this.validateCredentials(token, DeviceCredentialsType.ACCESS_TOKEN);
        }
        if (transportApiRequestMsg.hasValidateBasicMqttCredRequestMsg()) {
            TransportProtos.ValidateBasicMqttCredRequestMsg msg = transportApiRequestMsg.getValidateBasicMqttCredRequestMsg();
            return this.validateCredentials(msg);
        }
        if (transportApiRequestMsg.hasValidateX509CertRequestMsg()) {
            TransportProtos.ValidateDeviceX509CertRequestMsg msg = transportApiRequestMsg.getValidateX509CertRequestMsg();
            String hash = msg.getHash();
            return this.validateCredentials(hash, DeviceCredentialsType.X509_CERTIFICATE);
        }
        if (transportApiRequestMsg.hasValidateOrCreateX509CertRequestMsg()) {
            TransportProtos.ValidateOrCreateDeviceX509CertRequestMsg msg = transportApiRequestMsg.getValidateOrCreateX509CertRequestMsg();
            String certChain = msg.getCertificateChain();
            return this.validateOrCreateDeviceX509Certificate(certChain);
        }
        if (transportApiRequestMsg.hasGetOrCreateDeviceRequestMsg()) {
            return this.handle(transportApiRequestMsg.getGetOrCreateDeviceRequestMsg());
        }
        if (transportApiRequestMsg.hasEntityProfileRequestMsg()) {
            return this.handle(transportApiRequestMsg.getEntityProfileRequestMsg());
        }
        if (transportApiRequestMsg.hasLwM2MRequestMsg()) {
            return this.handle(transportApiRequestMsg.getLwM2MRequestMsg());
        }
        if (transportApiRequestMsg.hasValidateDeviceLwM2MCredentialsRequestMsg()) {
            TransportProtos.ValidateDeviceLwM2MCredentialsRequestMsg msg = transportApiRequestMsg.getValidateDeviceLwM2MCredentialsRequestMsg();
            String credentialsId = msg.getCredentialsId();
            return this.validateCredentials(credentialsId, DeviceCredentialsType.LWM2M_CREDENTIALS);
        }
        if (transportApiRequestMsg.hasProvisionDeviceRequestMsg()) {
            return this.handle(transportApiRequestMsg.getProvisionDeviceRequestMsg());
        }
        if (transportApiRequestMsg.hasResourceRequestMsg()) {
            return this.handle(transportApiRequestMsg.getResourceRequestMsg());
        }
        if (transportApiRequestMsg.hasSnmpDevicesRequestMsg()) {
            return this.handle(transportApiRequestMsg.getSnmpDevicesRequestMsg());
        }
        if (transportApiRequestMsg.hasDeviceRequestMsg()) {
            return this.handle(transportApiRequestMsg.getDeviceRequestMsg());
        }
        if (transportApiRequestMsg.hasDeviceCredentialsRequestMsg()) {
            return this.handle(transportApiRequestMsg.getDeviceCredentialsRequestMsg());
        }
        if (transportApiRequestMsg.hasOtaPackageRequestMsg()) {
            return this.handle(transportApiRequestMsg.getOtaPackageRequestMsg());
        }
        if (transportApiRequestMsg.hasGetAllQueueRoutingInfoRequestMsg()) {
            return this.handle(transportApiRequestMsg.getGetAllQueueRoutingInfoRequestMsg());
        }
        return this.getEmptyTransportApiResponse();
    }

    private TransportProtos.TransportApiResponseMsg validateCredentials(String credentialsId, DeviceCredentialsType credentialsType) {
        DeviceCredentials credentials = this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(credentialsId);
        if (credentials != null && credentials.getCredentialsType() == credentialsType) {
            return this.getDeviceInfo(credentials);
        }
        return this.getEmptyTransportApiResponse();
    }

    private TransportProtos.TransportApiResponseMsg validateCredentials(TransportProtos.ValidateBasicMqttCredRequestMsg mqtt) {
        if (StringUtils.isEmpty((String)mqtt.getUserName())) {
            DeviceCredentials credentials = this.checkMqttCredentials(mqtt, EncryptionUtil.getSha3Hash((String)mqtt.getClientId()));
            if (credentials != null) {
                return this.getDeviceInfo(credentials);
            }
            return this.getEmptyTransportApiResponse();
        }
        DeviceCredentials credentials = this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(EncryptionUtil.getSha3Hash((String)"|", (String[])new String[]{mqtt.getClientId(), mqtt.getUserName()}));
        if (DefaultTransportApiService.checkIsMqttCredentials((DeviceCredentials)credentials)) {
            BasicCredentialsValidationResult validationResult = this.validateMqttCredentials(mqtt, credentials);
            if (BasicCredentialsValidationResult.VALID.equals((Object)validationResult)) {
                return this.getDeviceInfo(credentials);
            }
            if (BasicCredentialsValidationResult.PASSWORD_MISMATCH.equals((Object)validationResult)) {
                return this.getEmptyTransportApiResponse();
            }
            return this.validateUserNameCredentials(mqtt);
        }
        return this.validateUserNameCredentials(mqtt);
    }

    protected TransportProtos.TransportApiResponseMsg validateOrCreateDeviceX509Certificate(String certificateChain) {
        List chain = X509_CERTIFICATE_TRIM_CHAIN_PATTERN.matcher(certificateChain).results().map(match -> EncryptionUtil.certTrimNewLines((String)match.group())).collect(Collectors.toList());
        for (String certificateValue : chain) {
            String certificateHash = EncryptionUtil.getSha3Hash((String)certificateValue);
            DeviceCredentials credentials = this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(certificateHash);
            if (credentials != null && DeviceCredentialsType.X509_CERTIFICATE.equals((Object)credentials.getCredentialsType())) {
                return this.getDeviceInfo(credentials);
            }
            DeviceProfile deviceProfile = this.deviceProfileService.findDeviceProfileByProvisionDeviceKey(certificateHash);
            if (deviceProfile != null && DeviceProfileProvisionType.X509_CERTIFICATE_CHAIN.equals((Object)deviceProfile.getProvisionType())) {
                String updatedDeviceProvisionSecret = (String)chain.get(0);
                ProvisionRequest provisionRequest = this.createProvisionRequest(updatedDeviceProvisionSecret);
                try {
                    ProvisionResponse provisionResponse = this.deviceProvisionService.provisionDeviceViaX509Chain(deviceProfile, provisionRequest);
                    if (!ProvisionResponseStatus.SUCCESS.equals((Object)provisionResponse.getResponseStatus())) continue;
                    return this.getDeviceInfo(provisionResponse.getDeviceCredentials());
                }
                catch (ProvisionFailedException e) {
                    log.debug("[{}][{}] Failed to provision device with cert chain: {}", new Object[]{deviceProfile.getTenantId(), deviceProfile.getId(), provisionRequest, e});
                    return this.getEmptyTransportApiResponse();
                }
            }
            if (deviceProfile == null) continue;
            log.warn("[{}][{}] Device Profile provision configuration mismatched: expected {}, actual {}", new Object[]{deviceProfile.getTenantId(), deviceProfile.getId(), DeviceProfileProvisionType.X509_CERTIFICATE_CHAIN, deviceProfile.getProvisionType()});
        }
        return this.getEmptyTransportApiResponse();
    }

    private TransportProtos.TransportApiResponseMsg validateUserNameCredentials(TransportProtos.ValidateBasicMqttCredRequestMsg mqtt) {
        DeviceCredentials credentials = this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(mqtt.getUserName());
        if (credentials != null) {
            switch (1.$SwitchMap$org$thingsboard$server$common$data$security$DeviceCredentialsType[credentials.getCredentialsType().ordinal()]) {
                case 1: {
                    return this.getDeviceInfo(credentials);
                }
                case 2: {
                    if (BasicCredentialsValidationResult.VALID.equals((Object)this.validateMqttCredentials(mqtt, credentials))) {
                        return this.getDeviceInfo(credentials);
                    }
                    return this.getEmptyTransportApiResponse();
                }
            }
        }
        return this.getEmptyTransportApiResponse();
    }

    private DeviceCredentials checkMqttCredentials(TransportProtos.ValidateBasicMqttCredRequestMsg clientCred, String credId) {
        return this.checkMqttCredentials(clientCred, this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(credId));
    }

    private DeviceCredentials checkMqttCredentials(TransportProtos.ValidateBasicMqttCredRequestMsg clientCred, DeviceCredentials deviceCredentials) {
        if (deviceCredentials != null && deviceCredentials.getCredentialsType() == DeviceCredentialsType.MQTT_BASIC && BasicCredentialsValidationResult.VALID.equals((Object)this.validateMqttCredentials(clientCred, deviceCredentials))) {
            return deviceCredentials;
        }
        return null;
    }

    private BasicCredentialsValidationResult validateMqttCredentials(TransportProtos.ValidateBasicMqttCredRequestMsg clientCred, DeviceCredentials deviceCredentials) {
        BasicMqttCredentials dbCred = (BasicMqttCredentials)JacksonUtil.fromString((String)deviceCredentials.getCredentialsValue(), BasicMqttCredentials.class);
        if (!StringUtils.isEmpty((String)dbCred.getClientId()) && !dbCred.getClientId().equals(clientCred.getClientId())) {
            return BasicCredentialsValidationResult.HASH_MISMATCH;
        }
        if (!StringUtils.isEmpty((String)dbCred.getUserName()) && !dbCred.getUserName().equals(clientCred.getUserName())) {
            return BasicCredentialsValidationResult.HASH_MISMATCH;
        }
        if (!StringUtils.isEmpty((String)dbCred.getPassword())) {
            if (StringUtils.isEmpty((String)clientCred.getPassword())) {
                return BasicCredentialsValidationResult.PASSWORD_MISMATCH;
            }
            return dbCred.getPassword().equals(clientCred.getPassword()) ? BasicCredentialsValidationResult.VALID : BasicCredentialsValidationResult.PASSWORD_MISMATCH;
        }
        return BasicCredentialsValidationResult.VALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.GetOrCreateDeviceFromGatewayRequestMsg requestMsg) {
        DeviceId gatewayId = new DeviceId(new UUID(requestMsg.getGatewayIdMSB(), requestMsg.getGatewayIdLSB()));
        Device gateway = this.deviceService.findDeviceById(TenantId.SYS_TENANT_ID, gatewayId);
        Lock deviceCreationLock = this.deviceCreationLocks.computeIfAbsent(requestMsg.getDeviceName(), id -> new ReentrantLock());
        deviceCreationLock.lock();
        try {
            DeviceProfile deviceProfile;
            Device device = this.deviceService.findDeviceByTenantIdAndName(gateway.getTenantId(), requestMsg.getDeviceName());
            if (device == null) {
                TenantId tenantId = gateway.getTenantId();
                device = new Device();
                device.setTenantId(tenantId);
                device.setName(requestMsg.getDeviceName());
                device.setType(requestMsg.getDeviceType());
                device.setCustomerId(gateway.getCustomerId());
                deviceProfile = this.deviceProfileCache.findOrCreateDeviceProfile(gateway.getTenantId(), requestMsg.getDeviceType());
                device.setDeviceProfileId(deviceProfile.getId());
                ObjectNode additionalInfo = JacksonUtil.newObjectNode();
                additionalInfo.put("lastConnectedGateway", gatewayId.toString());
                device.setAdditionalInfo((JsonNode)additionalInfo);
                device = this.deviceService.saveDevice(device);
                if (StringUtils.isNotBlank((String)requestMsg.getEntityGroup())) {
                    Customer customer = this.customerService.findCustomerById(tenantId, gateway.getCustomerId());
                    String description = "Autogenerated group for Sparkplug devices";
                    EntityGroup groupSparkplugDevice = customer != null ? this.entityGroupService.findOrCreateEntityGroup(tenantId, (EntityId)gateway.getCustomerId(), EntityType.DEVICE, requestMsg.getEntityGroup(), description, null) : this.entityGroupService.findOrCreateEntityGroup(tenantId, (EntityId)tenantId, EntityType.DEVICE, requestMsg.getEntityGroup(), description, null);
                    this.entityGroupService.addEntityToEntityGroup(tenantId, groupSparkplugDevice.getId(), (EntityId)device.getId());
                }
                this.relationService.saveRelation(tenantId, new EntityRelation((EntityId)gateway.getId(), (EntityId)device.getId(), "Created"));
                TbMsgMetaData metaData = new TbMsgMetaData();
                CustomerId customerId = gateway.getCustomerId();
                if (customerId != null && !customerId.isNullUid()) {
                    metaData.putValue("customerId", customerId.toString());
                }
                metaData.putValue("gatewayId", gatewayId.toString());
                DeviceId deviceId = device.getId();
                JsonNode entityNode = JacksonUtil.valueToTree((Object)device);
                TbMsg tbMsg = TbMsg.newMsg().type(TbMsgType.ENTITY_CREATED).originator((EntityId)deviceId).customerId(customerId).copyMetaData(metaData).dataType(TbMsgDataType.JSON).data(JacksonUtil.toString((Object)entityNode)).build();
                this.tbClusterService.pushMsgToRuleEngine(tenantId, (EntityId)deviceId, tbMsg, null);
            } else {
                JsonNode deviceAdditionalInfo = device.getAdditionalInfo();
                if (deviceAdditionalInfo == null) {
                    deviceAdditionalInfo = JacksonUtil.newObjectNode();
                }
                if (!(!deviceAdditionalInfo.isObject() || deviceAdditionalInfo.has("lastConnectedGateway") && gatewayId.toString().equals(deviceAdditionalInfo.get("lastConnectedGateway").asText()))) {
                    ObjectNode newDeviceAdditionalInfo = (ObjectNode)deviceAdditionalInfo;
                    newDeviceAdditionalInfo.put("lastConnectedGateway", gatewayId.toString());
                    this.deviceService.saveDevice(device);
                }
            }
            TransportProtos.GetOrCreateDeviceFromGatewayResponseMsg.Builder builder = TransportProtos.GetOrCreateDeviceFromGatewayResponseMsg.newBuilder().setDeviceInfo(ProtoUtils.toDeviceInfoProto((Device)device));
            deviceProfile = this.deviceProfileCache.get(device.getTenantId(), device.getDeviceProfileId());
            if (deviceProfile != null) {
                builder.setDeviceProfile(ProtoUtils.toProto((DeviceProfile)deviceProfile));
            } else {
                log.warn("[{}] Failed to find device profile [{}] for device. ", (Object)device.getId(), (Object)device.getDeviceProfileId());
            }
            TransportProtos.TransportApiResponseMsg transportApiResponseMsg = TransportProtos.TransportApiResponseMsg.newBuilder().setGetOrCreateDeviceResponseMsg(builder.build()).build();
            return transportApiResponseMsg;
        }
        catch (JsonProcessingException e) {
            log.warn("[{}] Failed to lookup device by gateway id and name: [{}]", new Object[]{gatewayId, requestMsg.getDeviceName(), e});
            throw new RuntimeException(e);
        }
        catch (EntitiesLimitExceededException e) {
            log.warn("[{}][{}] API limit exception: [{}]", new Object[]{e.getTenantId(), gatewayId, e.getMessage()});
            TransportProtos.TransportApiResponseMsg transportApiResponseMsg = TransportProtos.TransportApiResponseMsg.newBuilder().setGetOrCreateDeviceResponseMsg(TransportProtos.GetOrCreateDeviceFromGatewayResponseMsg.newBuilder().setError(TransportProtos.TransportApiRequestErrorCode.ENTITY_LIMIT)).build();
            return transportApiResponseMsg;
        }
        finally {
            deviceCreationLock.unlock();
        }
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.ProvisionDeviceRequestMsg requestMsg) {
        ProvisionResponse provisionResponse;
        try {
            provisionResponse = this.deviceProvisionService.provisionDevice(new ProvisionRequest(requestMsg.getDeviceName(), requestMsg.getCredentialsType() != null ? DeviceCredentialsType.valueOf((String)requestMsg.getCredentialsType().name()) : null, new ProvisionDeviceCredentialsData(requestMsg.getCredentialsDataProto().getValidateDeviceTokenRequestMsg().getToken(), requestMsg.getCredentialsDataProto().getValidateBasicMqttCredRequestMsg().getClientId(), requestMsg.getCredentialsDataProto().getValidateBasicMqttCredRequestMsg().getUserName(), requestMsg.getCredentialsDataProto().getValidateBasicMqttCredRequestMsg().getPassword(), requestMsg.getCredentialsDataProto().getValidateDeviceX509CertRequestMsg().getHash()), new ProvisionDeviceProfileCredentials(requestMsg.getProvisionDeviceCredentialsMsg().getProvisionDeviceKey(), requestMsg.getProvisionDeviceCredentialsMsg().getProvisionDeviceSecret()), Boolean.valueOf(requestMsg.getGateway())));
        }
        catch (ProvisionFailedException e) {
            return this.getTransportApiResponseMsg(new DeviceCredentials(), TransportProtos.ResponseStatus.valueOf((String)e.getMessage()));
        }
        return this.getTransportApiResponseMsg(provisionResponse.getDeviceCredentials(), TransportProtos.ResponseStatus.SUCCESS);
    }

    private TransportProtos.TransportApiResponseMsg getTransportApiResponseMsg(DeviceCredentials deviceCredentials, TransportProtos.ResponseStatus status) {
        if (!status.equals((Object)TransportProtos.ResponseStatus.SUCCESS)) {
            return TransportProtos.TransportApiResponseMsg.newBuilder().setProvisionDeviceResponseMsg(TransportProtos.ProvisionDeviceResponseMsg.newBuilder().setStatus(status).build()).build();
        }
        TransportProtos.ProvisionDeviceResponseMsg.Builder provisionResponse = TransportProtos.ProvisionDeviceResponseMsg.newBuilder().setCredentialsType(TransportProtos.CredentialsType.valueOf((String)deviceCredentials.getCredentialsType().name())).setStatus(status);
        switch (1.$SwitchMap$org$thingsboard$server$common$data$security$DeviceCredentialsType[deviceCredentials.getCredentialsType().ordinal()]) {
            case 1: {
                provisionResponse.setCredentialsValue(deviceCredentials.getCredentialsId());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                provisionResponse.setCredentialsValue(deviceCredentials.getCredentialsValue());
            }
        }
        return TransportProtos.TransportApiResponseMsg.newBuilder().setProvisionDeviceResponseMsg(provisionResponse.build()).build();
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.GetEntityProfileRequestMsg requestMsg) {
        EntityType entityType = EntityType.valueOf((String)requestMsg.getEntityType());
        UUID entityUuid = new UUID(requestMsg.getEntityIdMSB(), requestMsg.getEntityIdLSB());
        TransportProtos.GetEntityProfileResponseMsg.Builder builder = TransportProtos.GetEntityProfileResponseMsg.newBuilder();
        if (entityType.equals((Object)EntityType.DEVICE_PROFILE)) {
            DeviceProfileId deviceProfileId = new DeviceProfileId(entityUuid);
            DeviceProfile deviceProfile = this.deviceProfileCache.find(deviceProfileId);
            builder.setDeviceProfile(ProtoUtils.toProto((DeviceProfile)deviceProfile));
        } else if (entityType.equals((Object)EntityType.TENANT)) {
            TenantId tenantId = TenantId.fromUUID((UUID)entityUuid);
            TenantProfile tenantProfile = this.tenantProfileCache.get(tenantId);
            ApiUsageState state = this.apiUsageStateService.getApiUsageState(tenantId);
            builder.setTenantProfile(ProtoUtils.toProto((TenantProfile)tenantProfile));
            builder.setApiState(ProtoUtils.toProto((ApiUsageState)state));
        } else {
            throw new RuntimeException("Invalid entity profile request: " + String.valueOf(entityType));
        }
        return TransportProtos.TransportApiResponseMsg.newBuilder().setEntityProfileResponseMsg(builder).build();
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.GetDeviceRequestMsg requestMsg) {
        TransportProtos.TransportApiResponseMsg responseMsg;
        DeviceId deviceId = new DeviceId(new UUID(requestMsg.getDeviceIdMSB(), requestMsg.getDeviceIdLSB()));
        Device device = this.deviceService.findDeviceById(TenantId.SYS_TENANT_ID, deviceId);
        if (device != null) {
            UUID deviceProfileId = device.getDeviceProfileId().getId();
            responseMsg = TransportProtos.TransportApiResponseMsg.newBuilder().setDeviceResponseMsg(TransportProtos.GetDeviceResponseMsg.newBuilder().setDeviceProfileIdMSB(deviceProfileId.getMostSignificantBits()).setDeviceProfileIdLSB(deviceProfileId.getLeastSignificantBits()).setDeviceTransportConfiguration(ByteString.copyFrom((byte[])JacksonUtil.writeValueAsBytes((Object)device.getDeviceData().getTransportConfiguration())))).build();
        } else {
            responseMsg = TransportProtos.TransportApiResponseMsg.getDefaultInstance();
        }
        return responseMsg;
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.GetDeviceCredentialsRequestMsg requestMsg) {
        DeviceId deviceId = new DeviceId(new UUID(requestMsg.getDeviceIdMSB(), requestMsg.getDeviceIdLSB()));
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(TenantId.SYS_TENANT_ID, deviceId);
        return TransportProtos.TransportApiResponseMsg.newBuilder().setDeviceCredentialsResponseMsg(TransportProtos.GetDeviceCredentialsResponseMsg.newBuilder().setDeviceCredentialsData(ProtoUtils.toProto((DeviceCredentials)deviceCredentials))).build();
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.GetResourceRequestMsg requestMsg) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(requestMsg.getTenantIdMSB(), requestMsg.getTenantIdLSB()));
        ResourceType resourceType = ResourceType.valueOf((String)requestMsg.getResourceType());
        String resourceKey = requestMsg.getResourceKey();
        TransportProtos.GetResourceResponseMsg.Builder builder = TransportProtos.GetResourceResponseMsg.newBuilder();
        TbResource resource = this.resourceService.findResourceByTenantIdAndKey(tenantId, resourceType, resourceKey);
        if (resource == null && !tenantId.equals((Object)TenantId.SYS_TENANT_ID)) {
            resource = this.resourceService.findResourceByTenantIdAndKey(TenantId.SYS_TENANT_ID, resourceType, resourceKey);
        }
        if (resource != null) {
            builder.setResource(ProtoUtils.toProto((TbResource)resource));
        }
        return TransportProtos.TransportApiResponseMsg.newBuilder().setResourceResponseMsg(builder).build();
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.GetSnmpDevicesRequestMsg requestMsg) {
        PageLink pageLink = new PageLink(requestMsg.getPageSize(), requestMsg.getPage());
        PageData result = this.deviceService.findDevicesIdsByDeviceProfileTransportType(DeviceTransportType.SNMP, pageLink);
        TransportProtos.GetSnmpDevicesResponseMsg responseMsg = TransportProtos.GetSnmpDevicesResponseMsg.newBuilder().addAllIds((Iterable)result.getData().stream().map(UUID::toString).collect(Collectors.toList())).setHasNextPage(result.hasNext()).build();
        return TransportProtos.TransportApiResponseMsg.newBuilder().setSnmpDevicesResponseMsg(responseMsg).build();
    }

    TransportProtos.TransportApiResponseMsg getDeviceInfo(DeviceCredentials credentials) {
        Device device = this.deviceService.findDeviceById(TenantId.SYS_TENANT_ID, credentials.getDeviceId());
        if (device == null) {
            log.trace("[{}] Failed to lookup device by id", (Object)credentials.getDeviceId());
            return this.getEmptyTransportApiResponse();
        }
        try {
            TransportProtos.ValidateDeviceCredentialsResponseMsg.Builder builder = TransportProtos.ValidateDeviceCredentialsResponseMsg.newBuilder();
            builder.setDeviceInfo(ProtoUtils.toDeviceInfoProto((Device)device));
            DeviceProfile deviceProfile = this.deviceProfileCache.get(device.getTenantId(), device.getDeviceProfileId());
            if (deviceProfile != null) {
                builder.setDeviceProfile(ProtoUtils.toProto((DeviceProfile)deviceProfile));
            } else {
                log.warn("[{}] Failed to find device profile [{}] for device. ", (Object)device.getId(), (Object)device.getDeviceProfileId());
            }
            if (!StringUtils.isEmpty((String)credentials.getCredentialsValue())) {
                builder.setCredentialsBody(credentials.getCredentialsValue());
            }
            return TransportProtos.TransportApiResponseMsg.newBuilder().setValidateCredResponseMsg(builder.build()).build();
        }
        catch (JsonProcessingException e) {
            log.warn("[{}] Failed to lookup device by id", (Object)credentials.getDeviceId(), (Object)e);
            return this.getEmptyTransportApiResponse();
        }
    }

    private TransportProtos.TransportApiResponseMsg getEmptyTransportApiResponse() {
        return TransportProtos.TransportApiResponseMsg.newBuilder().setValidateCredResponseMsg(TransportProtos.ValidateDeviceCredentialsResponseMsg.getDefaultInstance()).build();
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.LwM2MRequestMsg requestMsg) {
        if (requestMsg.hasRegistrationMsg()) {
            return this.handleRegistration(requestMsg.getRegistrationMsg());
        }
        throw new RuntimeException("Not supported!");
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.GetOtaPackageRequestMsg requestMsg) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(requestMsg.getTenantIdMSB(), requestMsg.getTenantIdLSB()));
        DeviceId deviceId = new DeviceId(new UUID(requestMsg.getDeviceIdMSB(), requestMsg.getDeviceIdLSB()));
        OtaPackageType otaPackageType = OtaPackageType.valueOf((String)requestMsg.getType());
        Device device = this.deviceService.findDeviceById(tenantId, deviceId);
        if (device == null) {
            return this.getEmptyTransportApiResponse();
        }
        OtaPackageInfo otaPackageInfo = this.otaPackageService.findOtaPackageInfoByDeviceIdAndType(deviceId, otaPackageType);
        TransportProtos.GetOtaPackageResponseMsg.Builder builder = TransportProtos.GetOtaPackageResponseMsg.newBuilder();
        if (otaPackageInfo == null) {
            builder.setResponseStatus(TransportProtos.ResponseStatus.NOT_FOUND);
        } else if (otaPackageInfo.hasUrl()) {
            builder.setResponseStatus(TransportProtos.ResponseStatus.FAILURE);
            log.trace("[{}] Can`t send OtaPackage with URL data!", (Object)otaPackageInfo.getId());
        } else {
            OtaPackageId otaPackageId = otaPackageInfo.getId();
            builder.setResponseStatus(TransportProtos.ResponseStatus.SUCCESS);
            builder.setOtaPackageIdMSB(otaPackageId.getId().getMostSignificantBits());
            builder.setOtaPackageIdLSB(otaPackageId.getId().getLeastSignificantBits());
            builder.setType(otaPackageInfo.getType().name());
            builder.setTitle(otaPackageInfo.getTitle());
            builder.setVersion(otaPackageInfo.getVersion());
            builder.setFileName(otaPackageInfo.getFileName());
            builder.setContentType(otaPackageInfo.getContentType());
            if (!this.otaPackageDataCache.has(otaPackageId.toString())) {
                OtaPackage otaPackage = this.otaPackageService.findOtaPackageById(tenantId, otaPackageId);
                this.otaPackageDataCache.put(otaPackageId.toString(), otaPackage.getData().array());
            }
        }
        return TransportProtos.TransportApiResponseMsg.newBuilder().setOtaPackageResponseMsg(builder.build()).build();
    }

    private TransportProtos.TransportApiResponseMsg handleRegistration(TransportProtos.LwM2MRegistrationRequestMsg msg) {
        TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString(msg.getTenantId()));
        String deviceName = msg.getEndpoint();
        Lock deviceCreationLock = this.deviceCreationLocks.computeIfAbsent(deviceName, id -> new ReentrantLock());
        deviceCreationLock.lock();
        try {
            Device device = this.deviceService.findDeviceByTenantIdAndName(tenantId, deviceName);
            if (device == null) {
                device = new Device();
                device.setTenantId(tenantId);
                device.setName(deviceName);
                device.setType("LwM2M");
                device = this.deviceService.saveDevice(device);
            }
            TransportProtos.LwM2MRegistrationResponseMsg registrationResponseMsg = TransportProtos.LwM2MRegistrationResponseMsg.newBuilder().setDeviceInfo(ProtoUtils.toDeviceInfoProto((Device)device)).build();
            TransportProtos.LwM2MResponseMsg responseMsg = TransportProtos.LwM2MResponseMsg.newBuilder().setRegistrationMsg(registrationResponseMsg).build();
            TransportProtos.TransportApiResponseMsg transportApiResponseMsg = TransportProtos.TransportApiResponseMsg.newBuilder().setLwM2MResponseMsg(responseMsg).build();
            return transportApiResponseMsg;
        }
        catch (JsonProcessingException e) {
            log.warn("[{}][{}] Failed to lookup device by name", new Object[]{tenantId, deviceName, e});
            throw new RuntimeException(e);
        }
        finally {
            deviceCreationLock.unlock();
        }
    }

    private TransportProtos.TransportApiResponseMsg handle(TransportProtos.GetAllQueueRoutingInfoRequestMsg requestMsg) {
        List queues = this.queueService.findAllQueues();
        return TransportProtos.TransportApiResponseMsg.newBuilder().addAllGetQueueRoutingInfoResponseMsgs((Iterable)queues.stream().map(queue -> TransportProtos.GetQueueRoutingInfoResponseMsg.newBuilder().setTenantIdMSB(queue.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(queue.getTenantId().getId().getLeastSignificantBits()).setQueueIdMSB(((QueueId)queue.getId()).getId().getMostSignificantBits()).setQueueIdLSB(((QueueId)queue.getId()).getId().getLeastSignificantBits()).setQueueName(queue.getName()).setQueueTopic(queue.getTopic()).setPartitions(queue.getPartitions()).setDuplicateMsgToAllPartitions(queue.isDuplicateMsgToAllPartitions()).build()).collect(Collectors.toList())).build();
    }

    private ProvisionRequest createProvisionRequest(String certificateValue) {
        return new ProvisionRequest(null, DeviceCredentialsType.X509_CERTIFICATE, new ProvisionDeviceCredentialsData(null, null, null, null, certificateValue), null, null);
    }

    @ConstructorProperties(value={"deviceProfileCache", "tenantProfileCache", "apiUsageStateService", "deviceService", "deviceProfileService", "relationService", "deviceCredentialsService", "tbClusterService", "deviceProvisionService", "resourceService", "otaPackageService", "otaPackageDataCache", "queueService", "entityGroupService", "customerService"})
    @Generated
    public DefaultTransportApiService(TbDeviceProfileCache deviceProfileCache, TbTenantProfileCache tenantProfileCache, TbApiUsageStateService apiUsageStateService, DeviceService deviceService, DeviceProfileService deviceProfileService, RelationService relationService, DeviceCredentialsService deviceCredentialsService, TbClusterService tbClusterService, DeviceProvisionService deviceProvisionService, ResourceService resourceService, OtaPackageService otaPackageService, OtaPackageDataCache otaPackageDataCache, QueueService queueService, EntityGroupService entityGroupService, CustomerService customerService) {
        this.deviceProfileCache = deviceProfileCache;
        this.tenantProfileCache = tenantProfileCache;
        this.apiUsageStateService = apiUsageStateService;
        this.deviceService = deviceService;
        this.deviceProfileService = deviceProfileService;
        this.relationService = relationService;
        this.deviceCredentialsService = deviceCredentialsService;
        this.tbClusterService = tbClusterService;
        this.deviceProvisionService = deviceProvisionService;
        this.resourceService = resourceService;
        this.otaPackageService = otaPackageService;
        this.otaPackageDataCache = otaPackageDataCache;
        this.queueService = queueService;
        this.entityGroupService = entityGroupService;
        this.customerService = customerService;
    }
}

