/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.translation;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.translation.CustomTranslation;
import org.thingsboard.server.dao.translation.CustomTranslationService;
import org.thingsboard.server.dao.translation.TranslationCacheKey;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractEtagCacheService;
import org.thingsboard.server.service.translation.TbCustomTranslationService;

@Service
@TbCoreComponent
public class DefaultTbCustomTranslationService
extends AbstractEtagCacheService<TranslationCacheKey>
implements TbCustomTranslationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbCustomTranslationService.class);
    private final CustomTranslationService customTranslationService;
    private final TbClusterService clusterService;

    public DefaultTbCustomTranslationService(TbClusterService clusterService, CustomTranslationService customTranslationService, @Value(value="${cache.translation.etag.timeToLiveInMinutes:44640}") int cacheTtl, @Value(value="${cache.translation.etag.maxSize:1000000}") int cacheMaxSize) {
        super(cacheTtl, cacheMaxSize);
        this.clusterService = clusterService;
        this.customTranslationService = customTranslationService;
    }

    public void saveCustomTranslation(CustomTranslation customTranslation) {
        this.customTranslationService.saveCustomTranslation(customTranslation);
        this.evictFromCache(customTranslation.getTenantId());
    }

    public void patchCustomTranslation(TenantId tenantId, CustomerId customerId, String localeCode, JsonNode customTranslation) {
        this.customTranslationService.patchCustomTranslation(tenantId, customerId, localeCode, customTranslation);
        this.evictFromCache(tenantId);
    }

    public void deleteCustomTranslationKey(TenantId tenantId, CustomerId customerId, String localeCode, String keyPath) {
        this.customTranslationService.deleteCustomTranslationKeyByPath(tenantId, customerId, localeCode, keyPath);
        this.evictFromCache(tenantId);
    }

    public void deleteCustomTranslation(TenantId tenantId, CustomerId customerId, String localeCode) {
        this.customTranslationService.deleteCustomTranslation(tenantId, customerId, localeCode);
        this.evictFromCache(tenantId);
    }

    private void evictFromCache(TenantId tenantId) {
        this.evictETags(TranslationCacheKey.forTenant((TenantId)tenantId));
        this.clusterService.broadcastToCore(TransportProtos.ToCoreNotificationMsg.newBuilder().setTranslationCacheInvalidateMsg(TransportProtos.TranslationCacheInvalidateMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).build()).build());
    }

    public void evictETags(TranslationCacheKey cacheKey) {
        TenantId tenantId = cacheKey.getTenantId();
        if (tenantId.isSysTenantId()) {
            this.etagCache.invalidateAll();
        } else {
            this.invalidateByFilter(key -> tenantId.equals((Object)key.getTenantId()));
        }
    }
}

