/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.telemetry;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmCommentSubType;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmFilter;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmModificationRequest;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmQueryV2;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.notification.rule.trigger.AlarmTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmCommentService;
import org.thingsboard.server.service.subscription.TbSubscriptionUtils;
import org.thingsboard.server.service.telemetry.AbstractSubscriptionService;
import org.thingsboard.server.service.telemetry.AlarmSubscriptionService;
import org.thingsboard.server.service.telemetry.DefaultAlarmSubscriptionService;

@Service
public class DefaultAlarmSubscriptionService
extends AbstractSubscriptionService
implements AlarmSubscriptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAlarmSubscriptionService.class);
    private final AlarmService alarmService;
    private final TbAlarmCommentService alarmCommentService;
    private final TbApiUsageReportClient apiUsageClient;
    private final TbApiUsageStateService apiUsageStateService;
    private final NotificationRuleProcessor notificationRuleProcessor;

    protected String getExecutorPrefix() {
        return "alarm";
    }

    public AlarmApiCallResult createAlarm(AlarmCreateOrUpdateActiveRequest request) {
        boolean creationEnabled = this.apiUsageStateService.getApiUsageState(request.getTenantId()).isAlarmCreationEnabled();
        AlarmApiCallResult result = this.alarmService.createAlarm(request, creationEnabled);
        if (result.isCreated()) {
            this.apiUsageClient.report(request.getTenantId(), null, ApiUsageRecordKey.CREATED_ALARMS_COUNT);
        }
        return this.withWsCallback((AlarmModificationRequest)request, result);
    }

    public AlarmApiCallResult updateAlarm(AlarmUpdateRequest request) {
        return this.withWsCallback(this.alarmService.updateAlarm(request));
    }

    public AlarmApiCallResult acknowledgeAlarm(TenantId tenantId, AlarmId alarmId, long ackTs) {
        return this.withWsCallback(this.alarmService.acknowledgeAlarm(tenantId, alarmId, ackTs));
    }

    public AlarmApiCallResult clearAlarm(TenantId tenantId, AlarmId alarmId, long clearTs, JsonNode details) {
        return this.clearAlarm(tenantId, alarmId, clearTs, details, true);
    }

    public AlarmApiCallResult clearAlarm(TenantId tenantId, AlarmId alarmId, long clearTs, JsonNode details, boolean pushEvent) {
        return this.withWsCallback(this.alarmService.clearAlarm(tenantId, alarmId, clearTs, details, pushEvent));
    }

    public AlarmApiCallResult assignAlarm(TenantId tenantId, AlarmId alarmId, UserId assigneeId, long assignTs) {
        return this.withWsCallback(this.alarmService.assignAlarm(tenantId, alarmId, assigneeId, assignTs));
    }

    public AlarmApiCallResult unassignAlarm(TenantId tenantId, AlarmId alarmId, long assignTs) {
        return this.withWsCallback(this.alarmService.unassignAlarm(tenantId, alarmId, assignTs));
    }

    public boolean deleteAlarm(TenantId tenantId, AlarmId alarmId) {
        AlarmApiCallResult result = this.alarmService.delAlarm(tenantId, alarmId);
        this.onAlarmDeleted(result);
        return result.isSuccessful();
    }

    public ListenableFuture<Alarm> findAlarmByIdAsync(TenantId tenantId, AlarmId alarmId) {
        return this.alarmService.findAlarmByIdAsync(tenantId, alarmId);
    }

    public Alarm findAlarmById(TenantId tenantId, AlarmId alarmId) {
        return this.alarmService.findAlarmById(tenantId, alarmId);
    }

    public AlarmInfo findAlarmInfoById(TenantId tenantId, AlarmId alarmId) {
        return this.alarmService.findAlarmInfoById(tenantId, alarmId);
    }

    public PageData<AlarmInfo> findAlarms(TenantId tenantId, AlarmQuery query) {
        return this.alarmService.findAlarms(tenantId, query);
    }

    public PageData<AlarmInfo> findCustomerAlarms(TenantId tenantId, CustomerId customerId, AlarmQuery query) {
        return this.alarmService.findCustomerAlarms(tenantId, customerId, query);
    }

    public PageData<AlarmInfo> findAlarmsV2(TenantId tenantId, AlarmQueryV2 query) {
        return this.alarmService.findAlarmsV2(tenantId, query);
    }

    public PageData<AlarmInfo> findCustomerAlarmsV2(TenantId tenantId, CustomerId customerId, AlarmQueryV2 query) {
        return this.alarmService.findCustomerAlarmsV2(tenantId, customerId, query);
    }

    public AlarmSeverity findHighestAlarmSeverity(TenantId tenantId, EntityId entityId, AlarmSearchStatus alarmSearchStatus, AlarmStatus alarmStatus, String assigneeId) {
        return this.alarmService.findHighestAlarmSeverity(tenantId, entityId, alarmSearchStatus, alarmStatus, assigneeId);
    }

    public PageData<AlarmData> findAlarmDataByQueryForEntities(TenantId tenantId, MergedUserPermissions mergedUserPermissions, AlarmDataQuery query, Collection<EntityId> orderedEntityIds) {
        return this.alarmService.findAlarmDataByQueryForEntities(tenantId, mergedUserPermissions, query, orderedEntityIds);
    }

    public Alarm findLatestActiveByOriginatorAndType(TenantId tenantId, EntityId originator, String type) {
        return this.alarmService.findLatestActiveByOriginatorAndType(tenantId, originator, type);
    }

    public FluentFuture<Alarm> findLatestActiveByOriginatorAndTypeAsync(TenantId tenantId, EntityId originator, String type) {
        return this.alarmService.findLatestActiveByOriginatorAndTypeAsync(tenantId, originator, type);
    }

    public Alarm findLatestByOriginatorAndType(TenantId tenantId, EntityId originator, String type) {
        return this.alarmService.findLatestActiveByOriginatorAndType(tenantId, originator, type);
    }

    public List<Long> findAlarmCounts(TenantId tenantId, AlarmQuery query, List<AlarmFilter> filters) {
        return this.alarmService.findAlarmCounts(tenantId, query, filters);
    }

    public Set<EntityId> getPropagationEntityIds(Alarm alarm) {
        return this.alarmService.getPropagationEntityIds(alarm);
    }

    public Set<EntityId> getPropagationEntityIds(Alarm alarm, List<EntityType> types) {
        return this.alarmService.getPropagationEntityIds(alarm, types);
    }

    public PageData<EntitySubtype> findAlarmTypesByTenantId(TenantId tenantId, PageLink pageLink) {
        return this.alarmService.findAlarmTypesByTenantId(tenantId, pageLink);
    }

    private void onAlarmUpdated(AlarmApiCallResult result) {
        this.wsCallBackExecutor.submit(() -> {
            AlarmInfo alarm = result.getAlarm();
            TenantId tenantId = alarm.getTenantId();
            for (EntityId entityId : result.getPropagatedEntitiesList()) {
                this.forwardToSubscriptionManagerService(tenantId, entityId, subscriptionManagerService -> subscriptionManagerService.onAlarmUpdate(tenantId, entityId, alarm, TbCallback.EMPTY), () -> TbSubscriptionUtils.toAlarmUpdateProto((TenantId)tenantId, (EntityId)entityId, (AlarmInfo)alarm));
            }
            this.notificationRuleProcessor.process((NotificationRuleTrigger)AlarmTrigger.builder().tenantId(tenantId).alarmUpdate(result).build());
        });
    }

    private void onAlarmDeleted(AlarmApiCallResult result) {
        this.wsCallBackExecutor.submit(() -> {
            AlarmInfo alarm = result.getAlarm();
            TenantId tenantId = alarm.getTenantId();
            for (EntityId entityId : result.getPropagatedEntitiesList()) {
                this.forwardToSubscriptionManagerService(tenantId, entityId, subscriptionManagerService -> subscriptionManagerService.onAlarmDeleted(tenantId, entityId, alarm, TbCallback.EMPTY), () -> TbSubscriptionUtils.toAlarmDeletedProto((TenantId)tenantId, (EntityId)entityId, (AlarmInfo)alarm));
            }
            this.notificationRuleProcessor.process((NotificationRuleTrigger)AlarmTrigger.builder().tenantId(tenantId).alarmUpdate(result).build());
        });
    }

    private AlarmApiCallResult withWsCallback(AlarmApiCallResult result) {
        return this.withWsCallback(null, result);
    }

    private AlarmApiCallResult withWsCallback(AlarmModificationRequest request, AlarmApiCallResult result) {
        if (result.isSuccessful() && result.isModified()) {
            Futures.addCallback((ListenableFuture)Futures.immediateFuture((Object)result), (FutureCallback)new AlarmUpdateCallback(this), (Executor)this.wsCallBackExecutor);
            if (result.isSeverityChanged()) {
                AlarmInfo alarm = result.getAlarm();
                AlarmComment.AlarmCommentBuilder alarmComment = AlarmComment.builder().alarmId(alarm.getId()).type(AlarmCommentType.SYSTEM).comment((JsonNode)JacksonUtil.newObjectNode().put("text", String.format(AlarmCommentSubType.SEVERITY_CHANGED.getText(), result.getOldSeverity(), alarm.getSeverity())).put("subtype", AlarmCommentSubType.SEVERITY_CHANGED.name()).put("oldSeverity", result.getOldSeverity().name()).put("newSeverity", alarm.getSeverity().name()));
                if (request != null && request.getUserId() != null) {
                    alarmComment.userId(request.getUserId());
                }
                try {
                    this.alarmCommentService.saveAlarmComment((Alarm)alarm, alarmComment.build(), null);
                }
                catch (ThingsboardException e) {
                    log.error("Failed to save alarm comment", (Throwable)e);
                }
            }
        }
        return result;
    }

    @ConstructorProperties(value={"alarmService", "alarmCommentService", "apiUsageClient", "apiUsageStateService", "notificationRuleProcessor"})
    @Generated
    public DefaultAlarmSubscriptionService(AlarmService alarmService, TbAlarmCommentService alarmCommentService, TbApiUsageReportClient apiUsageClient, TbApiUsageStateService apiUsageStateService, NotificationRuleProcessor notificationRuleProcessor) {
        this.alarmService = alarmService;
        this.alarmCommentService = alarmCommentService;
        this.apiUsageClient = apiUsageClient;
        this.apiUsageStateService = apiUsageStateService;
        this.notificationRuleProcessor = notificationRuleProcessor;
    }
}

