/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.RuleChainExportData;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.rule.RuleNodeDao;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.rule.TbRuleChainService;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class RuleChainImportService
extends BaseEntityImportService<RuleChainId, RuleChain, RuleChainExportData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChainImportService.class);
    private static final LinkedHashSet<EntityType> HINTS = new LinkedHashSet<EntityType>(Arrays.asList(EntityType.RULE_CHAIN, EntityType.DEVICE, EntityType.ASSET));
    public static final Pattern PROCESSED_CONFIG_FIELDS_PATTERN = Pattern.compile(".*[iI]d.*");
    private final TbRuleChainService tbRuleChainService;
    private final RuleChainService ruleChainService;
    private final RuleNodeDao ruleNodeDao;

    protected void setOwner(TenantId tenantId, RuleChain ruleChain, BaseEntityImportService.IdProvider idProvider) {
        ruleChain.setTenantId(tenantId);
    }

    protected RuleChain findExistingEntity(EntitiesImportCtx ctx, RuleChain ruleChain, BaseEntityImportService.IdProvider idProvider) {
        RuleChain existingRuleChain = (RuleChain)super.findExistingEntity(ctx, (ExportableEntity)ruleChain, idProvider);
        if (existingRuleChain == null && ctx.isFindExistingByName()) {
            existingRuleChain = this.ruleChainService.findTenantRuleChainsByTypeAndName(ctx.getTenantId(), ruleChain.getType(), ruleChain.getName()).stream().findFirst().orElse(null);
        }
        return existingRuleChain;
    }

    protected RuleChain prepare(EntitiesImportCtx ctx, RuleChain ruleChain, RuleChain old, RuleChainExportData exportData, BaseEntityImportService.IdProvider idProvider) {
        RuleChainMetaData metaData = exportData.getMetaData();
        List<RuleNode> ruleNodes = Optional.ofNullable(metaData.getNodes()).orElse(Collections.emptyList());
        if (old != null) {
            List nodeIds = ruleNodes.stream().map(RuleNode::getId).collect(Collectors.toList());
            List existing = this.ruleNodeDao.findByExternalIds(old.getId(), nodeIds);
            existing.forEach(node -> ctx.putInternalId((EntityId)node.getExternalId(), (EntityId)node.getId()));
            ruleNodes.forEach(node -> {
                node.setRuleChainId(old.getId());
                node.setExternalId(node.getId());
                node.setId((UUIDBased)((RuleNodeId)ctx.getInternalId((EntityId)node.getId())));
            });
        } else {
            ruleNodes.forEach(node -> {
                node.setRuleChainId(null);
                node.setExternalId(node.getId());
                node.setId(null);
            });
        }
        ruleNodes.forEach(ruleNode -> this.replaceIdsRecursively(ctx, idProvider, ruleNode.getConfiguration(), Collections.emptySet(), PROCESSED_CONFIG_FIELDS_PATTERN, HINTS));
        Optional.ofNullable(metaData.getRuleChainConnections()).orElse(Collections.emptyList()).forEach(ruleChainConnectionInfo -> ruleChainConnectionInfo.setTargetRuleChainId((RuleChainId)idProvider.getInternalId((EntityId)ruleChainConnectionInfo.getTargetRuleChainId(), false)));
        if (ruleChain.getFirstRuleNodeId() != null) {
            ruleChain.setFirstRuleNodeId((RuleNodeId)ctx.getInternalId((EntityId)ruleChain.getFirstRuleNodeId()));
        }
        return ruleChain;
    }

    protected RuleChain saveOrUpdate(EntitiesImportCtx ctx, RuleChain ruleChain, RuleChainExportData exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        ruleChain = this.ruleChainService.saveRuleChain(ruleChain);
        if (ctx.isFinalImportAttempt() || ctx.getCurrentImportResult().isUpdatedAllExternalIds()) {
            exportData.getMetaData().setRuleChainId(ruleChain.getId());
            this.ruleChainService.saveRuleChainMetaData(ctx.getTenantId(), exportData.getMetaData(), arg_0 -> ((TbRuleChainService)this.tbRuleChainService).updateRuleNodeConfiguration(arg_0));
            return this.ruleChainService.findRuleChainById(ctx.getTenantId(), ruleChain.getId());
        }
        return ruleChain;
    }

    protected boolean isUpdateNeeded(EntitiesImportCtx ctx, RuleChainExportData exportData, RuleChain prepared, RuleChain existing) {
        boolean updateNeeded = super.isUpdateNeeded(ctx, (EntityExportData)exportData, (ExportableEntity)prepared, (ExportableEntity)existing);
        if (!updateNeeded) {
            RuleChainMetaData newMD = exportData.getMetaData();
            RuleChainMetaData existingMD = this.ruleChainService.loadRuleChainMetaData(ctx.getTenantId(), prepared.getId());
            existingMD.setRuleChainId(null);
            updateNeeded = !newMD.equals((Object)existingMD);
        }
        return updateNeeded;
    }

    protected void onEntitySaved(User user, RuleChain savedRuleChain, RuleChain oldRuleChain) {
        this.entityActionService.logEntityAction(user, (EntityId)savedRuleChain.getId(), (HasName)savedRuleChain, null, oldRuleChain == null ? ActionType.ADDED : ActionType.UPDATED, null, new Object[0]);
    }

    protected RuleChain deepCopy(RuleChain ruleChain) {
        return new RuleChain(ruleChain);
    }

    public EntityType getEntityType() {
        return EntityType.RULE_CHAIN;
    }

    @ConstructorProperties(value={"tbRuleChainService", "ruleChainService", "ruleNodeDao"})
    @Generated
    public RuleChainImportService(TbRuleChainService tbRuleChainService, RuleChainService ruleChainService, RuleNodeDao ruleNodeDao) {
        this.tbRuleChainService = tbRuleChainService;
        this.ruleChainService = ruleChainService;
        this.ruleNodeDao = ruleNodeDao;
    }
}

