/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.permission.UserPermissionsService;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class RoleImportService
extends BaseEntityImportService<RoleId, Role, EntityExportData<Role>> {
    private final RoleService roleService;
    private final UserPermissionsService userPermissionsService;

    protected void setOwner(TenantId tenantId, Role role, BaseEntityImportService.IdProvider idProvider) {
        role.setTenantId(tenantId);
        role.setCustomerId((CustomerId)idProvider.getInternalId((EntityId)role.getCustomerId()));
    }

    protected Role findExistingEntity(EntitiesImportCtx ctx, Role role, BaseEntityImportService.IdProvider idProvider) {
        Role existingRole = (Role)super.findExistingEntity(ctx, (ExportableEntity)role, idProvider);
        if (existingRole == null && ctx.isFindExistingByName()) {
            TenantId tenantId = ctx.getTenantId();
            existingRole = role.getOwnerId() == null || role.getOwnerId().getEntityType() == EntityType.TENANT ? (Role)this.roleService.findRoleByTenantIdAndName(tenantId, role.getName()).orElse(null) : (Role)this.roleService.findRoleByByTenantIdAndCustomerIdAndName(tenantId, (CustomerId)idProvider.getInternalId((EntityId)role.getCustomerId()), role.getName()).orElse(null);
        }
        return existingRole;
    }

    protected Role prepare(EntitiesImportCtx ctx, Role entity, Role oldEntity, EntityExportData<Role> exportData, BaseEntityImportService.IdProvider idProvider) {
        return entity;
    }

    protected Role deepCopy(Role role) {
        return new Role(role);
    }

    protected Role saveOrUpdate(EntitiesImportCtx ctx, Role role, EntityExportData<Role> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        return this.roleService.saveRole(ctx.getTenantId(), role);
    }

    protected void onEntitySaved(User user, Role savedRole, Role oldRole) throws ThingsboardException {
        this.logEntityActionService.logEntityAction(savedRole.getTenantId(), (EntityId)savedRole.getId(), (HasName)savedRole, null, oldRole == null ? ActionType.ADDED : ActionType.UPDATED, user, new Object[0]);
        this.userPermissionsService.onRoleUpdated(savedRole);
    }

    public EntityType getEntityType() {
        return EntityType.ROLE;
    }

    @ConstructorProperties(value={"roleService", "userPermissionsService"})
    @Generated
    public RoleImportService(RoleService roleService, UserPermissionsService userPermissionsService) {
        this.roleService = roleService;
        this.userPermissionsService = userPermissionsService;
    }
}

