/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.notification.rule.DefaultNotificationRuleRecipientsConfig;
import org.thingsboard.server.common.data.notification.rule.EscalatedNotificationRuleRecipientsConfig;
import org.thingsboard.server.common.data.notification.rule.NotificationRule;
import org.thingsboard.server.common.data.notification.rule.NotificationRuleRecipientsConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.DeviceActivityNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.EdgeCommunicationFailureNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.EdgeConnectionNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.IntegrationLifecycleEventNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.notification.rule.trigger.config.RuleEngineComponentLifecycleEventNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.notification.NotificationRuleService;
import org.thingsboard.server.dao.service.ConstraintValidator;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.ie.importing.impl.NotificationRuleImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class NotificationRuleImportService
extends BaseEntityImportService<NotificationRuleId, NotificationRule, EntityExportData<NotificationRule>> {
    private final NotificationRuleService notificationRuleService;

    protected void setOwner(TenantId tenantId, NotificationRule notificationRule, BaseEntityImportService.IdProvider idProvider) {
        notificationRule.setTenantId(tenantId);
    }

    protected NotificationRule prepare(EntitiesImportCtx ctx, NotificationRule notificationRule, NotificationRule oldNotificationRule, EntityExportData<NotificationRule> exportData, BaseEntityImportService.IdProvider idProvider) {
        notificationRule.setTemplateId((NotificationTemplateId)idProvider.getInternalId((EntityId)notificationRule.getTemplateId()));
        NotificationRuleTriggerConfig ruleTriggerConfig = notificationRule.getTriggerConfig();
        NotificationRuleTriggerType triggerType = ruleTriggerConfig.getTriggerType();
        switch (1.$SwitchMap$org$thingsboard$server$common$data$notification$rule$trigger$config$NotificationRuleTriggerType[triggerType.ordinal()]) {
            case 1: {
                Set deviceProfiles;
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (DeviceActivityNotificationRuleTriggerConfig)ruleTriggerConfig;
                Set devices = triggerConfig.getDevices();
                if (devices != null) {
                    triggerConfig.setDevices(devices.stream().map(DeviceId::new).map(arg_0 -> ((BaseEntityImportService.IdProvider)idProvider).getInternalId(arg_0)).map(UUIDBased::getId).collect(Collectors.toSet()));
                }
                if ((deviceProfiles = triggerConfig.getDeviceProfiles()) == null) break;
                triggerConfig.setDeviceProfiles(deviceProfiles.stream().map(DeviceProfileId::new).map(arg_0 -> ((BaseEntityImportService.IdProvider)idProvider).getInternalId(arg_0)).map(UUIDBased::getId).collect(Collectors.toSet()));
                break;
            }
            case 2: {
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (RuleEngineComponentLifecycleEventNotificationRuleTriggerConfig)ruleTriggerConfig;
                Set ruleChains = triggerConfig.getRuleChains();
                if (ruleChains == null) break;
                triggerConfig.setRuleChains(ruleChains.stream().map(RuleChainId::new).map(arg_0 -> ((BaseEntityImportService.IdProvider)idProvider).getInternalId(arg_0)).map(UUIDBased::getId).collect(Collectors.toSet()));
                break;
            }
            case 3: {
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (IntegrationLifecycleEventNotificationRuleTriggerConfig)ruleTriggerConfig;
                Set integrations = triggerConfig.getIntegrations();
                if (integrations == null) break;
                triggerConfig.setIntegrations(integrations.stream().map(IntegrationId::new).map(arg_0 -> ((BaseEntityImportService.IdProvider)idProvider).getInternalId(arg_0)).map(UUIDBased::getId).collect(Collectors.toSet()));
                break;
            }
            case 4: {
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (EdgeConnectionNotificationRuleTriggerConfig)ruleTriggerConfig;
                triggerConfig.setEdges(null);
                break;
            }
            case 5: {
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (EdgeCommunicationFailureNotificationRuleTriggerConfig)ruleTriggerConfig;
                triggerConfig.setEdges(null);
                break;
            }
        }
        if (!triggerType.isTenantLevel()) {
            throw new IllegalArgumentException("Trigger type " + String.valueOf(triggerType) + " is not available for tenants");
        }
        NotificationRuleRecipientsConfig ruleRecipientsConfig = notificationRule.getRecipientsConfig();
        switch (1.$SwitchMap$org$thingsboard$server$common$data$notification$rule$trigger$config$NotificationRuleTriggerType[triggerType.ordinal()]) {
            case 6: {
                EscalatedNotificationRuleRecipientsConfig recipientsConfig = (EscalatedNotificationRuleRecipientsConfig)ruleRecipientsConfig;
                LinkedHashMap<Integer, List> escalationTable = new LinkedHashMap<Integer, List>(recipientsConfig.getEscalationTable());
                escalationTable.replaceAll((delay, targets) -> targets.stream().map(NotificationTargetId::new).map(arg_0 -> ((BaseEntityImportService.IdProvider)idProvider).getInternalId(arg_0)).map(UUIDBased::getId).collect(Collectors.toList()));
                recipientsConfig.setEscalationTable(escalationTable);
                break;
            }
            default: {
                EscalatedNotificationRuleRecipientsConfig recipientsConfig = (DefaultNotificationRuleRecipientsConfig)ruleRecipientsConfig;
                List targets2 = recipientsConfig.getTargets().stream().map(NotificationTargetId::new).map(arg_0 -> ((BaseEntityImportService.IdProvider)idProvider).getInternalId(arg_0)).map(UUIDBased::getId).collect(Collectors.toList());
                recipientsConfig.setTargets(targets2);
                break;
            }
        }
        return notificationRule;
    }

    protected NotificationRule saveOrUpdate(EntitiesImportCtx ctx, NotificationRule notificationRule, EntityExportData<NotificationRule> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        ConstraintValidator.validateFields((Object)notificationRule);
        return this.notificationRuleService.saveNotificationRule(ctx.getTenantId(), notificationRule);
    }

    protected void onEntitySaved(User user, NotificationRule savedEntity, NotificationRule oldEntity) {
        this.entityActionService.logEntityAction(user, (EntityId)((NotificationRuleId)savedEntity.getId()), (HasName)savedEntity, null, oldEntity == null ? ActionType.ADDED : ActionType.UPDATED, null, new Object[0]);
    }

    protected NotificationRule deepCopy(NotificationRule notificationRule) {
        return new NotificationRule(notificationRule);
    }

    public EntityType getEntityType() {
        return EntityType.NOTIFICATION_RULE;
    }

    @ConstructorProperties(value={"notificationRuleService"})
    @Generated
    public NotificationRuleImportService(NotificationRuleService notificationRuleService) {
        this.notificationRuleService = notificationRuleService;
    }
}

