/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.sync.ie.DeviceExportData;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseGroupEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class DeviceImportService
extends BaseGroupEntityImportService<DeviceId, Device, DeviceExportData> {
    private final DeviceService deviceService;
    private final DeviceCredentialsService credentialsService;

    protected void setOwner(TenantId tenantId, Device device, BaseEntityImportService.IdProvider idProvider) {
        device.setTenantId(tenantId);
        device.setCustomerId((CustomerId)idProvider.getInternalId((EntityId)device.getCustomerId()));
    }

    protected Device prepare(EntitiesImportCtx ctx, Device device, Device old, DeviceExportData exportData, BaseEntityImportService.IdProvider idProvider) {
        device.setDeviceProfileId((DeviceProfileId)idProvider.getInternalId((EntityId)device.getDeviceProfileId()));
        device.setFirmwareId((OtaPackageId)idProvider.getInternalId((EntityId)device.getFirmwareId()));
        device.setSoftwareId((OtaPackageId)idProvider.getInternalId((EntityId)device.getSoftwareId()));
        return device;
    }

    protected Device deepCopy(Device d) {
        return new Device(d);
    }

    protected void cleanupForComparison(Device e) {
        super.cleanupForComparison((ExportableEntity)e);
        if (e.getCustomerId() != null && e.getCustomerId().isNullUid()) {
            e.setCustomerId(null);
        }
    }

    protected Device saveOrUpdate(EntitiesImportCtx ctx, Device device, DeviceExportData exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        Device savedDevice;
        if (exportData.getCredentials() != null && ctx.isSaveCredentials()) {
            exportData.getCredentials().setId(null);
            exportData.getCredentials().setDeviceId(null);
            savedDevice = this.deviceService.saveDeviceWithCredentials(device, exportData.getCredentials());
        } else {
            savedDevice = this.deviceService.saveDevice(device);
        }
        if (ctx.isFinalImportAttempt() || ctx.getCurrentImportResult().isUpdatedAllExternalIds()) {
            this.importCalculatedFields(ctx, (ExportableEntity)savedDevice, (EntityExportData)exportData, idProvider);
        }
        return savedDevice;
    }

    protected boolean updateRelatedEntitiesIfUnmodified(EntitiesImportCtx ctx, Device prepared, DeviceExportData exportData, BaseEntityImportService.IdProvider idProvider) {
        boolean updated = super.updateRelatedEntitiesIfUnmodified(ctx, (ExportableEntity)prepared, (EntityExportData)exportData, idProvider);
        DeviceCredentials credentials = exportData.getCredentials();
        if (credentials != null && ctx.isSaveCredentials()) {
            DeviceCredentials existing = this.credentialsService.findDeviceCredentialsByDeviceId(ctx.getTenantId(), prepared.getId());
            credentials.setId((UUIDBased)existing.getId());
            credentials.setDeviceId(prepared.getId());
            if (!existing.equals((Object)credentials)) {
                this.credentialsService.updateDeviceCredentials(ctx.getTenantId(), credentials);
                updated = true;
            }
        }
        return updated;
    }

    protected void onEntitySaved(User user, Device savedDevice, Device oldDevice) throws ThingsboardException {
        super.onEntitySaved(user, (ExportableEntity)savedDevice, (ExportableEntity)oldDevice);
    }

    public EntityType getEntityType() {
        return EntityType.DEVICE;
    }

    @ConstructorProperties(value={"deviceService", "credentialsService"})
    @Generated
    public DeviceImportService(DeviceService deviceService, DeviceCredentialsService credentialsService) {
        this.deviceService = deviceService;
        this.credentialsService = credentialsService;
    }
}

