/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.GroupEntityExportData;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseGroupEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class DashboardImportService
extends BaseGroupEntityImportService<DashboardId, Dashboard, GroupEntityExportData<Dashboard>> {
    private static final LinkedHashSet<EntityType> HINTS = new LinkedHashSet<EntityType>(Arrays.asList(EntityType.DASHBOARD, EntityType.DEVICE, EntityType.ASSET));
    public static final Pattern WIDGET_CONFIG_PROCESSED_FIELDS_PATTERN = Pattern.compile(".*Id.*");
    private final DashboardService dashboardService;

    protected void setOwner(TenantId tenantId, Dashboard dashboard, BaseEntityImportService.IdProvider idProvider) {
        dashboard.setTenantId(tenantId);
        dashboard.setCustomerId((CustomerId)idProvider.getInternalId((EntityId)dashboard.getCustomerId()));
    }

    protected Dashboard findExistingEntity(EntitiesImportCtx ctx, Dashboard dashboard, BaseEntityImportService.IdProvider idProvider) {
        Dashboard existingDashboard = (Dashboard)super.findExistingEntity(ctx, (ExportableEntity)dashboard, idProvider);
        if (existingDashboard == null && ctx.isFindExistingByName()) {
            existingDashboard = this.dashboardService.findTenantDashboardsByTitle(ctx.getTenantId(), dashboard.getName()).stream().findFirst().orElse(null);
        }
        return existingDashboard;
    }

    protected Dashboard prepare(EntitiesImportCtx ctx, Dashboard dashboard, Dashboard old, GroupEntityExportData<Dashboard> exportData, BaseEntityImportService.IdProvider idProvider) {
        for (JsonNode entityAlias : dashboard.getEntityAliasesConfig()) {
            this.replaceIdsRecursively(ctx, idProvider, entityAlias, Set.of("id"), null, HINTS);
        }
        for (JsonNode widgetConfig : dashboard.getWidgetsConfig()) {
            this.replaceIdsRecursively(ctx, idProvider, JacksonUtil.getSafely((JsonNode)widgetConfig, (String[])new String[]{"config", "actions"}), Collections.emptySet(), WIDGET_CONFIG_PROCESSED_FIELDS_PATTERN, HINTS);
        }
        return dashboard;
    }

    protected Dashboard saveOrUpdate(EntitiesImportCtx ctx, Dashboard dashboard, GroupEntityExportData<Dashboard> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        return this.dashboardService.saveDashboard(dashboard);
    }

    protected Dashboard deepCopy(Dashboard dashboard) {
        return new Dashboard(dashboard);
    }

    protected boolean isUpdateNeeded(EntitiesImportCtx ctx, GroupEntityExportData<Dashboard> exportData, Dashboard prepared, Dashboard existing) {
        return super.isUpdateNeeded(ctx, exportData, (ExportableEntity)prepared, (ExportableEntity)existing) || !prepared.getConfiguration().equals((Object)existing.getConfiguration());
    }

    public EntityType getEntityType() {
        return EntityType.DASHBOARD;
    }

    @ConstructorProperties(value={"dashboardService"})
    @Generated
    public DashboardImportService(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }
}

