/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class AssetProfileImportService
extends BaseEntityImportService<AssetProfileId, AssetProfile, EntityExportData<AssetProfile>> {
    private final AssetProfileService assetProfileService;

    protected void setOwner(TenantId tenantId, AssetProfile assetProfile, BaseEntityImportService.IdProvider idProvider) {
        assetProfile.setTenantId(tenantId);
    }

    protected AssetProfile prepare(EntitiesImportCtx ctx, AssetProfile assetProfile, AssetProfile old, EntityExportData<AssetProfile> exportData, BaseEntityImportService.IdProvider idProvider) {
        assetProfile.setDefaultRuleChainId((RuleChainId)idProvider.getInternalId((EntityId)assetProfile.getDefaultRuleChainId()));
        assetProfile.setDefaultDashboardId((DashboardId)idProvider.getInternalId((EntityId)assetProfile.getDefaultDashboardId()));
        assetProfile.setDefaultEdgeRuleChainId((RuleChainId)idProvider.getInternalId((EntityId)assetProfile.getDefaultEdgeRuleChainId()));
        return assetProfile;
    }

    protected AssetProfile saveOrUpdate(EntitiesImportCtx ctx, AssetProfile assetProfile, EntityExportData<AssetProfile> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        AssetProfile saved = this.assetProfileService.saveAssetProfile(assetProfile);
        if (ctx.isFinalImportAttempt() || ctx.getCurrentImportResult().isUpdatedAllExternalIds()) {
            this.importCalculatedFields(ctx, (ExportableEntity)saved, exportData, idProvider);
        }
        return saved;
    }

    protected void onEntitySaved(User user, AssetProfile savedAssetProfile, AssetProfile oldAssetProfile) {
        this.logEntityActionService.logEntityAction(savedAssetProfile.getTenantId(), (EntityId)savedAssetProfile.getId(), (HasName)savedAssetProfile, null, oldAssetProfile == null ? ActionType.ADDED : ActionType.UPDATED, user, new Object[0]);
    }

    protected AssetProfile deepCopy(AssetProfile assetProfile) {
        return new AssetProfile(assetProfile);
    }

    protected void cleanupForComparison(AssetProfile assetProfile) {
        super.cleanupForComparison((ExportableEntity)assetProfile);
    }

    public EntityType getEntityType() {
        return EntityType.ASSET_PROFILE;
    }

    @ConstructorProperties(value={"assetProfileService"})
    @Generated
    public AssetProfileImportService(AssetProfileService assetProfileService) {
        this.assetProfileService = assetProfileService;
    }
}

