/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.sync.ie.WidgetsBundleExportData;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class WidgetsBundleExportService
extends BaseEntityExportService<WidgetsBundleId, WidgetsBundle, WidgetsBundleExportData> {
    private final WidgetTypeService widgetTypeService;

    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, WidgetsBundle widgetsBundle, WidgetsBundleExportData exportData) {
        if (widgetsBundle.getTenantId() == null || widgetsBundle.getTenantId().isNullUid()) {
            throw new IllegalArgumentException("Export of system Widget Bundles is not allowed");
        }
        List fqns = this.widgetTypeService.findWidgetFqnsByWidgetsBundleId(ctx.getTenantId(), widgetsBundle.getId());
        exportData.setFqns(fqns);
    }

    protected WidgetsBundleExportData newExportData() {
        return new WidgetsBundleExportData();
    }

    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.WIDGETS_BUNDLE);
    }

    @ConstructorProperties(value={"widgetTypeService"})
    @Generated
    public WidgetsBundleExportService(WidgetTypeService widgetTypeService) {
        this.widgetTypeService = widgetTypeService;
    }
}

