/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.sync.ie.SchedulerEventExportData;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class SchedulerEventExportService
extends BaseEntityExportService<SchedulerEventId, SchedulerEvent, SchedulerEventExportData> {
    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, SchedulerEvent schedulerEvent, SchedulerEventExportData exportData) {
        schedulerEvent.setOriginatorId(this.getExternalIdOrElseInternal(ctx, schedulerEvent.getOriginatorId()));
        schedulerEvent.setCustomerId((CustomerId)this.getExternalIdOrElseInternal(ctx, (EntityId)schedulerEvent.getCustomerId()));
        JsonNode configuration = exportData.prepareConfiguration(schedulerEvent.getConfiguration(), schedulerEvent.getType(), id -> this.getExternalIdOrElseInternal(ctx, id), ctx.getUser().getId());
        schedulerEvent.setConfiguration(configuration);
    }

    protected SchedulerEventExportData newExportData() {
        return new SchedulerEventExportData();
    }

    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.SCHEDULER_EVENT);
    }
}

