/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.values;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Random;
import org.thingsboard.server.service.solutions.data.definition.TelemetryProfile;
import org.thingsboard.server.service.solutions.data.values.SequenceValueStrategyDefinition;
import org.thingsboard.server.service.solutions.data.values.TelemetryGenerator;

public class SequenceValueStrategyGenerator
extends TelemetryGenerator {
    private final SequenceValueStrategyDefinition strategy;
    private int max;
    private int index;

    public SequenceValueStrategyGenerator(TelemetryProfile telemetryProfile) {
        super(telemetryProfile);
        this.strategy = (SequenceValueStrategyDefinition)telemetryProfile.getValueStrategy();
        this.max = ((JsonNode)((Map.Entry)this.strategy.getTelemetry().fields().next()).getValue()).size() - 1;
        this.index = this.strategy.isRandom() ? new Random().nextInt(this.max + 1) : 0;
    }

    public void addValue(long ts, ObjectNode values) {
        this.strategy.getTelemetry().fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            values.set(key, ((JsonNode)entry.getValue()).get(this.index));
        });
        ++this.index;
        if (this.index > this.max) {
            this.index = 0;
        }
    }
}

