/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.values;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.thingsboard.server.service.solutions.data.definition.TelemetryProfile;
import org.thingsboard.server.service.solutions.data.values.EventValueStrategyDefinition;
import org.thingsboard.server.service.solutions.data.values.GeneratorTools;
import org.thingsboard.server.service.solutions.data.values.TelemetryGenerator;

public class EventTelemetryGenerator
extends TelemetryGenerator {
    private final EventValueStrategyDefinition strategy;
    private final long currentAnomaly;
    private Object value;

    public EventTelemetryGenerator(TelemetryProfile telemetryProfile) {
        super(telemetryProfile);
        this.strategy = (EventValueStrategyDefinition)telemetryProfile.getValueStrategy();
        this.currentAnomaly = GeneratorTools.randomLong((double)0.0, (double)this.strategy.getAnomalyChance());
    }

    public void addValue(long ts, ObjectNode values) {
        boolean anomaly = false;
        if (GeneratorTools.randomLong((double)0.0, (double)this.strategy.getAnomalyChance()) == this.currentAnomaly) {
            anomaly = true;
        }
        Object object = this.value = anomaly ? this.strategy.getAnomalyValue() : this.strategy.getNormalValue();
        if (this.value instanceof Boolean) {
            values.put(this.key, (Boolean)this.value);
        } else if (this.value instanceof Double) {
            values.put(this.key, (Double)this.value);
        } else if (this.value instanceof Integer) {
            values.put(this.key, (Integer)this.value);
        } else {
            throw new RuntimeException("Not supported value for event telemetry generator: " + String.valueOf(this.value));
        }
    }
}

