/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.values;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import org.thingsboard.server.service.solutions.data.definition.TelemetryProfile;
import org.thingsboard.server.service.solutions.data.values.CounterValueStrategyDefinition;
import org.thingsboard.server.service.solutions.data.values.GeneratorTools;
import org.thingsboard.server.service.solutions.data.values.TelemetryGenerator;

public class CounterTelemetryGenerator
extends TelemetryGenerator {
    private final CounterValueStrategyDefinition strategy;
    private double value;

    public CounterTelemetryGenerator(TelemetryProfile telemetryProfile) {
        super(telemetryProfile);
        this.strategy = (CounterValueStrategyDefinition)telemetryProfile.getValueStrategy();
        this.value = this.getRandomStartValue();
    }

    public void addValue(long ts, ObjectNode values) {
        double step = GeneratorTools.randomDouble((double)this.strategy.getMinIncrement(), (double)this.strategy.getMaxIncrement());
        double multiplier = GeneratorTools.getMultiplier((long)ts, (double)this.strategy.getHolidayMultiplier(), (double)this.strategy.getWorkHoursMultiplier(), (double)this.strategy.getNightHoursMultiplier());
        this.value += step * multiplier;
        if (this.value > this.getRandomEndValue()) {
            this.value = this.getRandomStartValue();
        }
        this.put(values, this.value);
    }

    private void put(ObjectNode values, double value) {
        if (this.strategy.getPrecision() == 0) {
            values.put(this.key, (int)value);
        } else {
            values.put(this.key, BigDecimal.valueOf(value).setScale(this.strategy.getPrecision(), RoundingMode.HALF_UP).doubleValue());
        }
    }

    public double getRandomStartValue() {
        return GeneratorTools.randomDouble((double)this.strategy.getMinStartValue(), (double)this.strategy.getMaxStartValue());
    }

    public double getRandomEndValue() {
        return GeneratorTools.randomDouble((double)this.strategy.getMinEndValue(), (double)this.strategy.getMaxEndValue());
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public void setValue(double value) {
        this.value = value;
    }
}

