/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.values;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.thingsboard.server.service.solutions.data.definition.TelemetryProfile;
import org.thingsboard.server.service.solutions.data.values.CompositeValueStrategyDefinition;
import org.thingsboard.server.service.solutions.data.values.GeneratorTools;
import org.thingsboard.server.service.solutions.data.values.TelemetryGenerator;
import org.thingsboard.server.service.solutions.data.values.TelemetryGeneratorFactory;

public class CompositeValueStrategyGenerator
extends TelemetryGenerator {
    TelemetryGenerator defaultGenerator;
    TelemetryGenerator whGenerator;
    TelemetryGenerator nhGenerator;
    TelemetryGenerator hhGenerator;

    public CompositeValueStrategyGenerator(TelemetryProfile tp) {
        super(tp);
        CompositeValueStrategyDefinition def = (CompositeValueStrategyDefinition)tp.getValueStrategy();
        this.defaultGenerator = TelemetryGeneratorFactory.create((TelemetryProfile)new TelemetryProfile(tp.getKey(), def.getDefaultHours()));
        if (def.getWorkHours() != null) {
            this.whGenerator = TelemetryGeneratorFactory.create((TelemetryProfile)new TelemetryProfile(tp.getKey(), def.getWorkHours()));
        }
        if (def.getNightHours() != null) {
            this.nhGenerator = TelemetryGeneratorFactory.create((TelemetryProfile)new TelemetryProfile(tp.getKey(), def.getNightHours()));
        }
        if (def.getHolidayHours() != null) {
            this.hhGenerator = TelemetryGeneratorFactory.create((TelemetryProfile)new TelemetryProfile(tp.getKey(), def.getHolidayHours()));
        }
    }

    public void addValue(long ts, ObjectNode values) {
        if (this.hhGenerator != null && GeneratorTools.isHoliday((long)ts)) {
            this.hhGenerator.addValue(ts, values);
        } else if (this.nhGenerator != null && GeneratorTools.isNightHour((long)ts)) {
            this.nhGenerator.addValue(ts, values);
        } else if (this.whGenerator != null && GeneratorTools.isWorkHour((long)ts)) {
            this.whGenerator.addValue(ts, values);
        } else {
            this.defaultGenerator.addValue(ts, values);
        }
    }
}

