/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.emulator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.service.solutions.data.definition.EmulatorDefinition;
import org.thingsboard.server.service.solutions.data.emulator.CustomEmulator;

public class FieldIrrigationStateEmulator
implements CustomEmulator {
    private static final int START_HOUR = 6;
    private int idx;
    private List<Pair<Long, ObjectNode>> data = new ArrayList();

    public void init(EmulatorDefinition emulatorDefinition) {
        this.idx = 0;
        TimeZone tz = TimeZone.getTimeZone("America/New_York");
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        c.setTimeZone(tz);
        int curHour = c.get(11);
        c.add(5, curHour < 6 ? -7 : -6);
        c.set(11, 6);
        c.set(12, 0);
        this.add(c, JacksonUtil.newObjectNode().put("startTs", c.getTimeInMillis()).put("durationThreshold", 1800000).put("consumption", 423).put("duration", 1800000));
        this.add(c, JacksonUtil.newObjectNode().put("startTs", c.getTimeInMillis()).put("durationThreshold", 1800000).put("consumption", 407).put("duration", 1800000));
        this.add(c, JacksonUtil.newObjectNode().put("startTs", c.getTimeInMillis()).put("consumptionThreshold", 1000).put("consumption", 1000).put("duration", 3780000));
        this.add(c, JacksonUtil.newObjectNode().put("startTs", c.getTimeInMillis()).put("consumptionThreshold", 500).put("consumption", 500).put("duration", 2160000));
        this.add(c, JacksonUtil.newObjectNode().put("startTs", c.getTimeInMillis()).put("consumptionThreshold", 1000).put("consumption", 1000).put("duration", 3780000));
        this.add(c, JacksonUtil.newObjectNode().put("startTs", c.getTimeInMillis()).put("durationThreshold", 1800000).put("duration", 1800000).put("consumption", 452));
        this.add(c, JacksonUtil.newObjectNode().put("startTs", c.getTimeInMillis()).put("durationThreshold", 1800000).put("duration", 1800000).put("consumption", 447));
    }

    private void add(Calendar c, ObjectNode objectNode) {
        ObjectNode startIrrigationMsg = JacksonUtil.newObjectNode();
        startIrrigationMsg.put("irrigationState", "DONE");
        startIrrigationMsg.set("irrigationTask", (JsonNode)objectNode);
        this.data.add(Pair.of((Object)c.getTimeInMillis(), (Object)startIrrigationMsg));
        c.add(5, 1);
    }

    public Pair<Long, ObjectNode> getNextValue() {
        if (this.idx < this.data.size()) {
            Pair result = (Pair)this.data.get(this.idx);
            ++this.idx;
            return result;
        }
        return null;
    }
}

