/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.emulator;

import com.google.common.util.concurrent.FutureCallback;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.service.solutions.data.definition.EmulatorDefinition;
import org.thingsboard.server.service.solutions.data.emulator.AbstractEmulatorLauncher;
import org.thingsboard.server.service.solutions.data.emulator.DeviceEmulatorLauncher;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

public class DeviceEmulatorLauncher
extends AbstractEmulatorLauncher<Device> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceEmulatorLauncher.class);

    public DeviceEmulatorLauncher(Device entity, EmulatorDefinition emulatorDefinition, ExecutorService oldTelemetryExecutor, TbClusterService tbClusterService, PartitionService partitionService, TbQueueProducerProvider tbQueueProducerProvider, TbServiceInfoProvider serviceInfoProvider, TelemetrySubscriptionService tsSubService) throws Exception {
        super((GroupEntity)entity, emulatorDefinition, oldTelemetryExecutor, tbClusterService, partitionService, tbQueueProducerProvider, serviceInfoProvider, tsSubService);
    }

    protected void postProcessEntity(Device entity) {
        if (this.emulatorDefinition.getActivityPeriodInMillis() > 0L) {
            this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(entity.getTenantId()).entityId((EntityId)entity.getId()).scope(AttributeScope.SERVER_SCOPE).entry((KvEntry)new LongDataEntry("inactivityTimeout", Long.valueOf(this.emulatorDefinition.getActivityPeriodInMillis()))).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
        }
    }

    @Generated
    public static DeviceEmulatorLauncherBuilder builder() {
        return new DeviceEmulatorLauncherBuilder();
    }
}

