/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data;

import java.util.UUID;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.solutions.data.HasAppliedToEntity;

public record CreatedCalculatedFieldInfo(EntityId entityId, String entityName, String type, String name) implements HasAppliedToEntity
{
    private final EntityId entityId;
    private final String entityName;
    private final String type;
    private final String name;

    public CreatedCalculatedFieldInfo(EntityId entityId, String entityName, String type, String name) {
        this.entityId = entityId;
        this.entityName = entityName;
        this.type = type;
        this.name = name;
    }

    public static CreatedCalculatedFieldInfo from(EntityId entityId, String entityName, CalculatedField calculatedField) {
        return new CreatedCalculatedFieldInfo(entityId, entityName, calculatedField.getType().getDisplayName(), calculatedField.getName());
    }

    public String getCfPageLink(UUID cfId) {
        return "/calculatedFields/" + String.valueOf(cfId);
    }

    public EntityId entityId() {
        return this.entityId;
    }

    public String entityName() {
        return this.entityName;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }
}

