/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data;

import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.AlarmCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.solutions.data.HasAppliedToEntity;

public record CreatedAlarmRuleInfo(EntityId entityId, String entityName, String alarmType, String severities) implements HasAppliedToEntity
{
    private final EntityId entityId;
    private final String entityName;
    private final String alarmType;
    private final String severities;

    public CreatedAlarmRuleInfo(EntityId entityId, String entityName, String alarmType, String severities) {
        this.entityId = entityId;
        this.entityName = entityName;
        this.alarmType = alarmType;
        this.severities = severities;
    }

    public static CreatedAlarmRuleInfo from(EntityId entityId, String entityName, CalculatedField calculatedField) {
        if (calculatedField.getType() != CalculatedFieldType.ALARM) {
            throw new UnsupportedOperationException("Only alarm calculated fields are supported");
        }
        String severities = ((AlarmCalculatedFieldConfiguration)calculatedField.getConfiguration()).getCreateRules().keySet().stream().map(AlarmSeverity::getDisplayName).sorted().collect(Collectors.joining(", "));
        return new CreatedAlarmRuleInfo(entityId, entityName, calculatedField.getName(), severities);
    }

    public String getCfPageLink(UUID cfId) {
        return "/alarms/alarm-rules/" + String.valueOf(cfId);
    }

    public EntityId entityId() {
        return this.entityId;
    }

    public String entityName() {
        return this.entityName;
    }

    public String alarmType() {
        return this.alarmType;
    }

    public String severities() {
        return this.severities;
    }
}

