/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sms.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.sms.exception.SmsException;
import org.thingsboard.rule.engine.api.sms.exception.SmsSendException;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.sms.config.AwsSnsSmsProviderConfiguration;
import org.thingsboard.server.service.sms.AbstractSmsSender;

public class AwsSmsSender
extends AbstractSmsSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AwsSmsSender.class);
    private static final Map<String, MessageAttributeValue> SMS_ATTRIBUTES = new HashMap();
    private AmazonSNS snsClient;

    public AwsSmsSender(AwsSnsSmsProviderConfiguration config) {
        if (StringUtils.isEmpty((String)config.getAccessKeyId()) || StringUtils.isEmpty((String)config.getSecretAccessKey()) || StringUtils.isEmpty((String)config.getRegion())) {
            throw new IllegalArgumentException("Invalid AWS sms provider configuration: aws accessKeyId, aws secretAccessKey and aws region should be specified!");
        }
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(config.getAccessKeyId(), config.getSecretAccessKey());
        AWSStaticCredentialsProvider credProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        this.snsClient = (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClient.builder().withCredentials((AWSCredentialsProvider)credProvider)).withRegion(config.getRegion())).build();
    }

    public int sendSms(String numberTo, String message) throws SmsException {
        numberTo = this.validatePhoneNumber(numberTo);
        message = this.prepareMessage(message);
        try {
            PublishRequest publishRequest = new PublishRequest().withMessageAttributes(SMS_ATTRIBUTES).withPhoneNumber(numberTo).withMessage(message);
            this.snsClient.publish(publishRequest);
            return this.countMessageSegments(message);
        }
        catch (Exception e) {
            throw new SmsSendException("Failed to send SMS message - " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        if (this.snsClient != null) {
            try {
                this.snsClient.shutdown();
            }
            catch (Exception e) {
                log.error("Failed to shutdown SNS client during destroy()", (Throwable)e);
            }
        }
    }

    static {
        SMS_ATTRIBUTES.put("AWS.SNS.SMS.SMSType", new MessageAttributeValue().withStringValue("Transactional").withDataType("String"));
    }
}

