/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.system;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.core.AuthenticationException;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.model.UserPasswordPolicy;
import org.thingsboard.server.common.data.security.model.mfa.PlatformTwoFaSettings;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.AccessJwtToken;

public interface SystemSecurityService {
    public void validatePasswordByPolicy(String var1, UserPasswordPolicy var2);

    public void validateUserCredentials(TenantId var1, UserCredentials var2, String var3, String var4) throws AuthenticationException;

    public void validateTwoFaVerification(SecurityUser var1, boolean var2, PlatformTwoFaSettings var3);

    public void validatePassword(String var1, UserCredentials var2) throws DataValidationException;

    public String getBaseUrl(Authority var1, TenantId var2, CustomerId var3, HttpServletRequest var4);

    public String getBaseUrl(TenantId var1, CustomerId var2, HttpServletRequest var3);

    public void logLoginAction(User var1, Object var2, ActionType var3, Exception var4);

    public void logLoginAction(User var1, Object var2, ActionType var3, String var4, Exception var5);

    public AccessJwtToken createUserAccessToken(TenantId var1, UserId var2) throws ThingsboardException;

    public AccessJwtToken createUserAccessTokenFromPublicId(TenantId var1, String var2) throws ThingsboardException;
}

