/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.rest;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.model.SecuritySettings;
import org.thingsboard.server.common.data.security.model.UserPasswordPolicy;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.settings.SecuritySettingsService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.AbstractAuthenticationProvider;
import org.thingsboard.server.service.security.auth.MfaAuthenticationToken;
import org.thingsboard.server.service.security.auth.MfaConfigurationToken;
import org.thingsboard.server.service.security.auth.mfa.TwoFactorAuthService;
import org.thingsboard.server.service.security.exception.UserPasswordNotValidException;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.permission.UserPermissionsService;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@Component
@TbCoreComponent
public class RestAuthenticationProvider
extends AbstractAuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestAuthenticationProvider.class);
    private final SystemSecurityService systemSecurityService;
    private final SecuritySettingsService securitySettingsService;
    private final UserService userService;
    private final UserPermissionsService userPermissionsService;
    private final TwoFactorAuthService twoFactorAuthService;

    @Autowired
    public RestAuthenticationProvider(UserService userService, CustomerService customerService, UserPermissionsService userPermissionsService, SystemSecurityService systemSecurityService, SecuritySettingsService securitySettingsService, TwoFactorAuthService twoFactorAuthService) {
        super(customerService, null, userPermissionsService);
        this.userService = userService;
        this.userPermissionsService = userPermissionsService;
        this.systemSecurityService = systemSecurityService;
        this.securitySettingsService = securitySettingsService;
        this.twoFactorAuthService = twoFactorAuthService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        SecurityUser securityUser;
        Assert.notNull((Object)authentication, (String)"No authentication data provided");
        Object principal = authentication.getPrincipal();
        if (!(principal instanceof UserPrincipal)) {
            throw new BadCredentialsException("Authentication Failed. Bad user principal.");
        }
        UserPrincipal userPrincipal = (UserPrincipal)principal;
        if (userPrincipal.getType() == UserPrincipal.Type.USER_NAME) {
            String username = userPrincipal.getValue();
            String password = (String)authentication.getCredentials();
            SecuritySettings securitySettings = this.securitySettingsService.getSecuritySettings();
            UserPasswordPolicy passwordPolicy = securitySettings.getPasswordPolicy();
            if (Boolean.TRUE.equals(passwordPolicy.getForceUserToResetPasswordIfNotValid())) {
                try {
                    this.systemSecurityService.validatePasswordByPolicy(password, passwordPolicy);
                }
                catch (DataValidationException e) {
                    throw new UserPasswordNotValidException("The entered password violates our policies. If this is your real password, please reset it.");
                }
            }
            if (this.twoFactorAuthService.isTwoFaEnabled((securityUser = this.authenticateByUsernameAndPassword(authentication, userPrincipal, username, password)).getTenantId(), (User)securityUser)) {
                return new MfaAuthenticationToken(securityUser);
            }
            if (this.twoFactorAuthService.isEnforceTwoFaEnabled(securityUser.getTenantId(), (User)securityUser)) {
                return new MfaConfigurationToken(securityUser);
            }
            this.systemSecurityService.logLoginAction((User)securityUser, authentication.getDetails(), ActionType.LOGIN, null);
        } else {
            String publicId = userPrincipal.getValue();
            securityUser = this.authenticateByPublicId(userPrincipal, publicId);
        }
        return new UsernamePasswordAuthenticationToken((Object)securityUser, null, securityUser.getAuthorities());
    }

    private SecurityUser authenticateByUsernameAndPassword(Authentication authentication, UserPrincipal userPrincipal, String username, String password) {
        User user = this.userService.findUserByEmail(TenantId.SYS_TENANT_ID, username);
        if (user == null) {
            throw new UsernameNotFoundException("User not found: " + username);
        }
        try {
            MergedUserPermissions userPermissions;
            UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(TenantId.SYS_TENANT_ID, user.getId());
            if (userCredentials == null) {
                throw new UsernameNotFoundException("User credentials not found");
            }
            try {
                this.systemSecurityService.validateUserCredentials(user.getTenantId(), userCredentials, username, password);
            }
            catch (LockedException e) {
                this.systemSecurityService.logLoginAction(user, authentication.getDetails(), ActionType.LOCKOUT, null);
                throw e;
            }
            if (user.getAuthority() == null) {
                throw new InsufficientAuthenticationException("User has no authority assigned");
            }
            try {
                userPermissions = this.userPermissionsService.getMergedPermissions(user, false);
            }
            catch (Exception e) {
                throw new BadCredentialsException("Failed to get user permissions", (Throwable)e);
            }
            return new SecurityUser(user, userCredentials.isEnabled(), userPrincipal, userPermissions);
        }
        catch (Exception e) {
            this.systemSecurityService.logLoginAction(user, authentication.getDetails(), ActionType.LOGIN, e);
            throw e;
        }
    }

    private SecurityUser authenticateByPublicId(UserPrincipal userPrincipal, String publicId) {
        return super.authenticateByPublicId(publicId, "Public Id", userPrincipal);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

