/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.oauth2.OAuth2User;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.entitiy.tenant.TbTenantService;
import org.thingsboard.server.service.entitiy.user.TbUserService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

public abstract class AbstractOAuth2ClientMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractOAuth2ClientMapper.class);
    @Autowired
    private UserService userService;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private TbTenantService tbTenantService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private UserPermissionsService userPermissionsService;
    @Autowired
    private EntityGroupService entityGroupService;
    @Autowired
    private OwnersCacheService ownersCacheService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private TbUserService tbUserService;
    @Autowired
    protected TbTenantProfileCache tenantProfileCache;
    @Value(value="${edges.enabled}")
    private boolean edgesEnabled;
    private final Lock userCreationLock = new ReentrantLock();

    protected SecurityUser getOrCreateSecurityUserFromOAuth2User(OAuth2User oauth2User, OAuth2Client oAuth2Client) {
        SecurityUser securityUser;
        JsonNode additionalInfo;
        OAuth2MapperConfig config = oAuth2Client.getMapperConfig();
        UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, oauth2User.getEmail());
        User user = this.userService.findUserByEmail(TenantId.SYS_TENANT_ID, oauth2User.getEmail());
        if (user == null && !config.isAllowUserCreation()) {
            throw new UsernameNotFoundException("User not found: " + oauth2User.getEmail());
        }
        boolean isNewUser = false;
        if (user == null) {
            this.userCreationLock.lock();
            try {
                user = this.userService.findUserByEmail(TenantId.SYS_TENANT_ID, oauth2User.getEmail());
                if (user == null) {
                    user = new User();
                    if (oauth2User.getCustomerId() == null && StringUtils.isEmpty((String)oauth2User.getCustomerName())) {
                        user.setAuthority(Authority.TENANT_ADMIN);
                    } else {
                        user.setAuthority(Authority.CUSTOMER_USER);
                    }
                    TenantId tenantId = oauth2User.getTenantId() != null ? oauth2User.getTenantId() : this.getTenantId(oauth2User.getTenantName());
                    user.setTenantId(tenantId);
                    CustomerId parentCustomerId = oauth2User.getParentCustomerId() != null ? oauth2User.getParentCustomerId() : this.getCustomerId(user.getTenantId(), oauth2User.getParentCustomerName(), null);
                    CustomerId customerId = oauth2User.getCustomerId() != null ? oauth2User.getCustomerId() : this.getCustomerId(user.getTenantId(), oauth2User.getCustomerName(), parentCustomerId);
                    user.setCustomerId(customerId);
                    user.setEmail(oauth2User.getEmail());
                    user.setFirstName(oauth2User.getFirstName());
                    user.setLastName(oauth2User.getLastName());
                    additionalInfo = JacksonUtil.newObjectNode();
                    if (oAuth2Client.getAdditionalInfo() != null && oAuth2Client.getAdditionalInfo().has("providerName")) {
                        additionalInfo.put("authProviderName", oAuth2Client.getAdditionalInfo().get("providerName").asText());
                    }
                    user.setAdditionalInfo(additionalInfo);
                    user = this.tbUserService.save(tenantId, customerId, null, user, false, null, (EntityGroup)null, null);
                    if (config.isActivateUser()) {
                        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(user.getTenantId(), user.getId());
                        this.userService.activateUserCredentials(user.getTenantId(), userCredentials.getActivateToken(), this.passwordEncoder.encode((CharSequence)""));
                    }
                    isNewUser = true;
                }
            }
            catch (Exception e) {
                log.error("Can't get or create security user from oauth2 user", (Throwable)e);
                throw new RuntimeException("Can't get or create security user from oauth2 user", e);
            }
            finally {
                this.userCreationLock.unlock();
            }
            try {
                ListenableFuture future = this.addUserToUserGroups(oauth2User, user);
                future.get();
            }
            catch (Exception e) {
                log.error("Error while adding user to entity groups", (Throwable)e);
                throw new RuntimeException("Error while adding user to entity groups", e);
            }
        }
        try {
            securityUser = new SecurityUser(user, true, principal, this.getMergedUserPermissions(user));
        }
        catch (Exception e) {
            log.error("Can't get or create security user from oauth2 user", (Throwable)e);
            throw new RuntimeException("Can't get or create security user from oauth2 user", e);
        }
        if (isNewUser && !StringUtils.isEmpty((String)oauth2User.getDefaultDashboardName())) {
            TenantId tenantId = user.getTenantId();
            try {
                Optional dashboardIdOpt = this.findDefaultDashboard(oauth2User, securityUser, tenantId);
                if (dashboardIdOpt.isPresent()) {
                    additionalInfo = (user = this.userService.findUserById(user.getTenantId(), user.getId())).getAdditionalInfo();
                    if (additionalInfo == null || additionalInfo instanceof NullNode) {
                        additionalInfo = JacksonUtil.newObjectNode();
                    }
                    ((ObjectNode)additionalInfo).put("defaultDashboardFullscreen", oauth2User.isAlwaysFullScreen());
                    ((ObjectNode)additionalInfo).put("defaultDashboardId", ((DashboardId)dashboardIdOpt.get()).getId().toString());
                    user.setAdditionalInfo(additionalInfo);
                    user = this.userService.saveUser(tenantId, user);
                    securityUser = new SecurityUser(user, true, principal, this.getMergedUserPermissions(user));
                }
            }
            catch (Exception e) {
                log.error("Error while setting default dashboard for user", (Throwable)e);
            }
        }
        try {
            return (SecurityUser)new UsernamePasswordAuthenticationToken((Object)securityUser, null, securityUser.getAuthorities()).getPrincipal();
        }
        catch (Exception e) {
            log.error("Can't create authentication token from security user", (Throwable)e);
            throw new RuntimeException("Can't create authentication token from security user", e);
        }
    }

    private Optional<DashboardId> findDefaultDashboard(OAuth2User oauth2User, SecurityUser securityUser, TenantId tenantId) throws Exception {
        PageLink pageLink = new PageLink(1, 0, oauth2User.getDefaultDashboardName());
        return this.ownersCacheService.getGroupEntities(tenantId, securityUser, EntityType.DASHBOARD, Operation.READ, pageLink, groupIds -> this.dashboardService.findDashboardsByEntityGroupIds(groupIds, pageLink)).getData().stream().findAny().map(IdBased::getId);
    }

    private ListenableFuture<Void> addUserToUserGroups(OAuth2User oauth2User, User user) {
        ArrayList<EntityGroupId> addedEntityGroups = new ArrayList<EntityGroupId>();
        try {
            EntityGroup allUserGroup = this.entityGroupService.findOrCreateUserGroup(user.getTenantId(), user.getOwnerId(), "All", "");
            addedEntityGroups.add(allUserGroup.getId());
            if (oauth2User.getUserGroups() != null && !oauth2User.getUserGroups().isEmpty()) {
                for (String group : oauth2User.getUserGroups()) {
                    EntityGroup userGroup = this.entityGroupService.findOrCreateUserGroup(user.getTenantId(), user.getOwnerId(), group, "");
                    if (userGroup == null) continue;
                    addedEntityGroups.add(userGroup.getId());
                    this.entityGroupService.addEntityToEntityGroup(user.getTenantId(), userGroup.getId(), (EntityId)user.getId());
                }
            }
        }
        catch (Exception e) {
            log.error("Can't add user [{}] to user groups", (Object)user.getEmail(), (Object)e);
            throw new RuntimeException("Can't add user to user groups", e);
        }
        ListenableFuture future = this.entityGroupService.findEntityGroupsForEntityAsync(user.getTenantId(), (EntityId)user.getId());
        return Futures.transformAsync((ListenableFuture)future, currentEntityGroups -> {
            if (currentEntityGroups != null && !currentEntityGroups.isEmpty()) {
                for (EntityGroupId currentEntityGroupId : currentEntityGroups) {
                    if (addedEntityGroups.contains(currentEntityGroupId)) continue;
                    this.entityGroupService.removeEntityFromEntityGroup(user.getTenantId(), currentEntityGroupId, (EntityId)user.getId());
                }
            }
            return Futures.immediateFuture(null);
        }, (Executor)MoreExecutors.directExecutor());
    }

    private MergedUserPermissions getMergedUserPermissions(User user) {
        try {
            return this.userPermissionsService.getMergedPermissions(user, false);
        }
        catch (Exception e) {
            throw new BadCredentialsException("Failed to get user permissions", (Throwable)e);
        }
    }

    private TenantId getTenantId(String name) throws Exception {
        Tenant tenant = this.tenantService.findTenantByName(name);
        if (tenant != null) {
            return tenant.getId();
        }
        tenant = new Tenant();
        tenant.setTitle(name);
        tenant = this.tbTenantService.save(tenant);
        return tenant.getId();
    }

    private CustomerId getCustomerId(TenantId tenantId, String customerName, CustomerId parentCustomerId) {
        if (StringUtils.isEmpty((String)customerName)) {
            return null;
        }
        Optional customerOpt = this.customerService.findCustomerByTenantIdAndTitle(tenantId, customerName);
        if (customerOpt.isPresent()) {
            return ((Customer)customerOpt.get()).getId();
        }
        Customer customer = new Customer();
        customer.setTenantId(tenantId);
        customer.setTitle(customerName);
        customer.setParentCustomerId(parentCustomerId);
        return this.customerService.saveCustomer(customer).getId();
    }

    @Generated
    public boolean isEdgesEnabled() {
        return this.edgesEnabled;
    }
}

