/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.jwt;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class SkipPathRequestMatcher
implements RequestMatcher {
    private final OrRequestMatcher skipMatchers;
    private final OrRequestMatcher processMatchers;

    public SkipPathRequestMatcher(List<String> pathsToSkip, List<String> pathsToProcess) {
        Assert.notNull(pathsToSkip, (String)"List of paths to skip is required.");
        List skip = pathsToSkip.stream().map(AntPathRequestMatcher::new).collect(Collectors.toList());
        List process = pathsToProcess.stream().map(AntPathRequestMatcher::new).collect(Collectors.toList());
        this.skipMatchers = new OrRequestMatcher(skip);
        this.processMatchers = new OrRequestMatcher(process);
    }

    public boolean matches(HttpServletRequest request) {
        if (this.skipMatchers.matches(request)) {
            return false;
        }
        return this.processMatchers.matches(request);
    }
}

