/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.jwt;

import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.service.security.auth.AbstractAuthenticationProvider;
import org.thingsboard.server.service.security.auth.RefreshAuthenticationToken;
import org.thingsboard.server.service.security.auth.TokenOutdatingService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;
import org.thingsboard.server.service.security.model.token.RawAccessJwtToken;
import org.thingsboard.server.service.security.permission.UserPermissionsService;
import org.thingsboard.server.service.user.cache.UserAuthDetailsCache;

@Component
public class RefreshTokenAuthenticationProvider
extends AbstractAuthenticationProvider {
    private final JwtTokenFactory tokenFactory;
    private final TokenOutdatingService tokenOutdatingService;

    public RefreshTokenAuthenticationProvider(JwtTokenFactory jwtTokenFactory, UserAuthDetailsCache userAuthDetailsCache, UserPermissionsService userPermissionsService, CustomerService customerService, TokenOutdatingService tokenOutdatingService) {
        super(customerService, userAuthDetailsCache, userPermissionsService);
        this.tokenFactory = jwtTokenFactory;
        this.tokenOutdatingService = tokenOutdatingService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.notNull((Object)authentication, (String)"No authentication data provided");
        RawAccessJwtToken rawAccessToken = (RawAccessJwtToken)authentication.getCredentials();
        SecurityUser unsafeUser = this.tokenFactory.parseRefreshToken(rawAccessToken.token());
        UserPrincipal principal = unsafeUser.getUserPrincipal();
        SecurityUser securityUser = principal.getType() == UserPrincipal.Type.USER_NAME ? this.authenticateByUserId(TenantId.SYS_TENANT_ID, unsafeUser.getId(), null) : this.authenticateByPublicId(principal.getValue());
        securityUser.setSessionId(unsafeUser.getSessionId());
        if (this.tokenOutdatingService.isOutdated(rawAccessToken.token(), securityUser.getId())) {
            throw new CredentialsExpiredException("Token is outdated");
        }
        return new RefreshAuthenticationToken(securityUser);
    }

    private SecurityUser authenticateByPublicId(String publicId) {
        return super.authenticateByPublicId(publicId, "Refresh token", null);
    }

    public boolean supports(Class<?> authentication) {
        return RefreshAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

