/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.UserAuthDetails;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.permission.AuthorityPermissionsInfo;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.permission.UserPermissionsService;
import org.thingsboard.server.service.user.cache.UserAuthDetailsCache;

public abstract class AbstractAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthenticationProvider.class);
    private final CustomerService customerService;
    private final UserAuthDetailsCache userAuthDetailsCache;
    private final UserPermissionsService userPermissionsService;

    protected SecurityUser authenticateByPublicId(String publicId, String authContextName, UserPrincipal userPrincipal) {
        MergedUserPermissions userPermissions;
        CustomerId customerId;
        TenantId systemId = TenantId.SYS_TENANT_ID;
        try {
            customerId = new CustomerId(UUID.fromString(publicId));
        }
        catch (Exception e) {
            throw new BadCredentialsException(authContextName + " is not valid");
        }
        Customer publicCustomer = this.customerService.findCustomerById(systemId, customerId);
        if (publicCustomer == null) {
            throw new UsernameNotFoundException("Public entity not found");
        }
        if (!publicCustomer.isPublic()) {
            throw new BadCredentialsException(authContextName + " is not valid");
        }
        User user = new User(new UserId(EntityId.NULL_UUID));
        user.setTenantId(publicCustomer.getTenantId());
        user.setCustomerId(publicCustomer.getId());
        user.setEmail(publicId);
        user.setAuthority(Authority.CUSTOMER_USER);
        user.setFirstName("Public");
        user.setLastName("Public");
        UserPrincipal principal = userPrincipal == null ? new UserPrincipal(UserPrincipal.Type.PUBLIC_ID, publicId) : userPrincipal;
        try {
            userPermissions = this.userPermissionsService.getMergedPermissions(user, true);
        }
        catch (Exception e) {
            throw new BadCredentialsException("Failed to get user permissions", (Throwable)e);
        }
        return new SecurityUser(user, true, principal, userPermissions);
    }

    protected SecurityUser authenticateByUserId(TenantId tenantId, UserId userId, AuthorityPermissionsInfo permissionsInfo) {
        MergedUserPermissions userPermissions;
        Map permissions;
        UserAuthDetails userAuthDetails = this.userAuthDetailsCache.getUserAuthDetails(tenantId, userId);
        if (userAuthDetails == null) {
            throw new UsernameNotFoundException("User with credentials not found");
        }
        if (!userAuthDetails.credentialsEnabled()) {
            throw new DisabledException("User is not active");
        }
        User user = userAuthDetails.user();
        if (user.getAuthority() == null) {
            throw new InsufficientAuthenticationException("User has no authority assigned");
        }
        UserPrincipal userPrincipal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
        if (permissionsInfo != null && (permissions = permissionsInfo.getPermissionsForAuthority(user.getAuthority())) != null && !permissions.isEmpty()) {
            MergedUserPermissions userPermissions2 = new MergedUserPermissions(permissions, new HashMap());
            return new SecurityUser(user, true, userPrincipal, userPermissions2);
        }
        try {
            userPermissions = this.userPermissionsService.getMergedPermissions(user, false);
        }
        catch (Exception e) {
            throw new BadCredentialsException("Failed to get user permissions", (Throwable)e);
        }
        return new SecurityUser(user, true, userPrincipal, userPermissions);
    }

    @ConstructorProperties(value={"customerService", "userAuthDetailsCache", "userPermissionsService"})
    @Generated
    public AbstractAuthenticationProvider(CustomerService customerService, UserAuthDetailsCache userAuthDetailsCache, UserPermissionsService userPermissionsService) {
        this.customerService = customerService;
        this.userAuthDetailsCache = userAuthDetailsCache;
        this.userPermissionsService = userPermissionsService;
    }
}

