/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security;

import com.google.common.util.concurrent.FutureCallback;
import org.thingsboard.server.exception.AccessDeniedException;
import org.thingsboard.server.exception.EntityNotFoundException;
import org.thingsboard.server.exception.InternalErrorException;
import org.thingsboard.server.exception.UnauthorizedException;
import org.thingsboard.server.service.security.ValidationCallback;
import org.thingsboard.server.service.security.ValidationResult;
import org.thingsboard.server.service.security.ValidationResultCode;

/*
 * Exception performing whole class analysis ignored.
 */
public class ValidationCallback<T>
implements FutureCallback<ValidationResult> {
    private final T response;
    private final FutureCallback<T> action;

    public ValidationCallback(T response, FutureCallback<T> action) {
        this.response = response;
        this.action = action;
    }

    public void onSuccess(ValidationResult result) {
        if (result.getResultCode() == ValidationResultCode.OK) {
            this.action.onSuccess(this.response);
        } else {
            this.onFailure((Throwable)ValidationCallback.getException((ValidationResult)result));
        }
    }

    public void onFailure(Throwable e) {
        this.action.onFailure(e);
    }

    public static Exception getException(ValidationResult result) {
        ValidationResultCode resultCode = result.getResultCode();
        return switch (1.$SwitchMap$org$thingsboard$server$service$security$ValidationResultCode[resultCode.ordinal()]) {
            case 1 -> new EntityNotFoundException(result.getMessage());
            case 2 -> new UnauthorizedException(result.getMessage());
            case 3 -> new AccessDeniedException(result.getMessage());
            case 4 -> new InternalErrorException(result.getMessage());
            default -> new UnauthorizedException("Permission denied.");
        };
    }
}

