/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.secret;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.secret.Secret;
import org.thingsboard.server.dao.encryptionkey.EncryptionService;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.dao.secret.SecretService;

@Service
public class DefaultSecretConfigurationService
implements SecretConfigurationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretConfigurationService.class);
    private static final Pattern SECRET_PATTERN = Pattern.compile("\\$\\{secret:([^;{}]+);type:([^;{}]+)}");
    private final SecretService secretService;
    private final EncryptionService encryptionService;

    public void replaceSecretUsages(TenantId tenantId, JsonNode config) {
        this.replaceAllSecretUsages(tenantId, config);
    }

    public <T> T replaceSecretUsages(TenantId tenantId, T entity, Class<T> clazz) {
        JsonNode config = JacksonUtil.valueToTree(entity);
        JsonNode replaced = this.replaceAllSecretUsages(tenantId, config);
        return (T)JacksonUtil.treeToValue((JsonNode)replaced, clazz);
    }

    public String replaceSecretUsage(TenantId tenantId, String value) {
        Matcher matcher = SECRET_PATTERN.matcher(value);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String name = matcher.group(1);
            Secret secret = this.secretService.findSecretByName(tenantId, name);
            String replacement = "";
            if (secret != null) {
                replacement = this.encryptionService.decryptToString(tenantId, secret.getType(), secret.getEncryptedValue());
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private JsonNode replaceAllSecretUsages(TenantId tenantId, JsonNode config) {
        JacksonUtil.replaceAll((JsonNode)config, (String)"", (path, value) -> this.replaceSecretUsage(tenantId, value));
        return config;
    }

    @ConstructorProperties(value={"secretService", "encryptionService"})
    @Generated
    public DefaultSecretConfigurationService(SecretService secretService, EncryptionService encryptionService) {
        this.secretService = secretService;
        this.encryptionService = encryptionService;
    }
}

