/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.scheduler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.ReportJobConfiguration;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.report.ReportConfig;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.ota.DeviceGroupOtaPackageService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.scheduler.BaseSchedulerEventService;
import org.thingsboard.server.dao.scheduler.SchedulerEventService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ota.OtaPackageStateService;
import org.thingsboard.server.service.partition.AbstractPartitionBasedService;
import org.thingsboard.server.service.scheduler.DefaultSchedulerService;
import org.thingsboard.server.service.scheduler.SchedulerEventMetaData;
import org.thingsboard.server.service.scheduler.SchedulerService;

@TbCoreComponent
@Service
public class DefaultSchedulerService
extends AbstractPartitionBasedService<TenantId>
implements SchedulerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSchedulerService.class);
    private final TenantService tenantService;
    private final TbClusterService clusterService;
    private final PartitionService partitionService;
    private final SchedulerEventService schedulerEventService;
    private final OtaPackageStateService firmwareStateService;
    private final DeviceService deviceService;
    private final DeviceProfileService deviceProfileService;
    private final EntityGroupService entityGroupService;
    private final DeviceGroupOtaPackageService deviceGroupOtaPackageService;
    private final OtaPackageService otaPackageService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final JobManager jobManager;
    @Value(value="${server.rest.server_side_rpc.min_timeout:5000}")
    protected long minTimeout;
    private final ConcurrentMap<TenantId, List<SchedulerEventId>> tenantEvents = new ConcurrentHashMap();
    private final ConcurrentMap<SchedulerEventId, SchedulerEventMetaData> eventsMetaData = new ConcurrentHashMap();
    volatile boolean firstRun = true;
    private String serviceId;

    @PostConstruct
    public void init() {
        super.init();
        this.serviceId = this.serviceInfoProvider.getServiceId();
    }

    @PreDestroy
    public void stop() {
        super.stop();
    }

    protected String getServiceName() {
        return "Scheduler";
    }

    protected String getSchedulerExecutorName() {
        return "scheduler-service";
    }

    public void onSchedulerEventAdded(SchedulerEventInfo event) {
        this.sendSchedulerEvent(event.getTenantId(), event.getId(), true, false, false);
    }

    public void onSchedulerEventUpdated(SchedulerEventInfo event) {
        this.sendSchedulerEvent(event.getTenantId(), event.getId(), false, true, false);
    }

    public void onSchedulerEventDeleted(SchedulerEventInfo event) {
        this.sendSchedulerEvent(event.getTenantId(), event.getId(), false, false, true);
    }

    public void onQueueMsg(TransportProtos.SchedulerServiceMsgProto proto, TbCallback callback) {
        log.debug("onQueueMsg proto {}", (Object)proto);
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB()));
        SchedulerEventId eventId = new SchedulerEventId(new UUID(proto.getEventIdMSB(), proto.getEventIdLSB()));
        if (proto.getDeleted()) {
            this.onEventDeleted(eventId);
        } else {
            SchedulerEventInfo event = this.schedulerEventService.findSchedulerEventInfoById(tenantId, eventId);
            if (event != null) {
                if (proto.getAdded() && !this.eventsMetaData.containsKey(event.getId())) {
                    this.scheduleAndAddToMap(event);
                } else {
                    SchedulerEventMetaData oldMd = (SchedulerEventMetaData)this.eventsMetaData.remove(event.getId());
                    if (oldMd != null && oldMd.getNextTaskFuture() != null) {
                        oldMd.getNextTaskFuture().cancel(false);
                    }
                    this.scheduleAndAddToMap(event);
                }
            }
        }
        callback.onSuccess();
    }

    protected Map<TopicPartitionInfo, List<ListenableFuture<?>>> onAddedPartitions(Set<TopicPartitionInfo> addedPartitions) {
        log.info("Scheduler service {}", (Object)(this.firstRun ? "Initializing" : "Updating"));
        long ts = System.currentTimeMillis();
        PageDataIterable tenantIterator = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenants(arg_0), 1024);
        for (Tenant tenant : tenantIterator) {
            TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenant.getId(), (EntityId)tenant.getId());
            if (!addedPartitions.contains(tpi)) continue;
            this.addToPartitionedTenants(tenant, tpi);
            this.addEventsForTenant(ts, tenant);
        }
        log.info("Scheduler service {}.", (Object)(this.firstRun ? "initialized" : "updated"));
        this.firstRun = false;
        return Collections.emptyMap();
    }

    protected void cleanupEntityOnPartitionRemoval(TenantId entityId) {
        this.removeEvents(entityId);
    }

    void removeEvents(TenantId tenantId) {
        this.tenantEvents.getOrDefault(tenantId, Collections.emptyList()).forEach(arg_0 -> this.onEventDeleted(arg_0));
        this.tenantEvents.remove(tenantId);
    }

    void addToPartitionedTenants(Tenant tenant, TopicPartitionInfo tpi) {
        this.partitionedEntities.computeIfAbsent(tpi, key -> ConcurrentHashMap.newKeySet()).add(tenant.getId());
    }

    private void addEventsForTenant(long ts, Tenant tenant) {
        log.debug("[{}] Fetching scheduled events for tenant.", (Object)tenant.getId());
        ArrayList<SchedulerEventId> eventIds = new ArrayList<SchedulerEventId>();
        List events = this.schedulerEventService.findSchedulerEventsByTenantIdAndEnabled(tenant.getId(), true);
        long scheduled = 0L;
        long passedAway = 0L;
        for (SchedulerEventInfo event : events) {
            SchedulerEventMetaData md = this.getSchedulerEventMetaData(event);
            if (!md.getDescriptor().passedAway(ts)) {
                this.eventsMetaData.put(event.getId(), md);
                eventIds.add(event.getId());
                ++scheduled;
            } else {
                ++passedAway;
            }
            this.scheduleNextEvent(ts, event, md);
        }
        this.tenantEvents.put(tenant.getId(), eventIds);
        log.debug("[{}] Fetched scheduled events for tenant. Scheduling {} events. Found {} passed events.", new Object[]{tenant.getId(), scheduled, passedAway});
    }

    private void scheduleNextEvent(long ts, SchedulerEventInfo event, SchedulerEventMetaData md) {
        if (!event.isEnabled()) {
            return;
        }
        long eventTs = md.getDescriptor().getNextEventTime(ts);
        if (eventTs != 0L) {
            log.debug("schedule next event for ts {}, event {}, metadata {}", new Object[]{ts, event, md});
            long eventDelay = eventTs - ts;
            md.setNextTaskFuture(this.scheduledExecutor.schedule(() -> this.processEvent(event.getTenantId(), event.getId()), eventDelay, TimeUnit.MILLISECONDS));
        }
    }

    private SchedulerEventMetaData getSchedulerEventMetaData(SchedulerEventInfo event) {
        return new SchedulerEventMetaData(event.toDescriptor());
    }

    private void processEvent(TenantId tenantId, SchedulerEventId eventId) {
        block24: {
            log.debug("processEvent tenant {}, event {}", (Object)tenantId, (Object)eventId);
            SchedulerEventMetaData md = (SchedulerEventMetaData)this.eventsMetaData.get(eventId);
            if (md != null) {
                try {
                    SchedulerEvent event = this.schedulerEventService.findSchedulerEventById(tenantId, eventId);
                    if (event != null) {
                        try {
                            JsonNode configuration = event.getConfiguration();
                            String msgType = this.getMsgType(event, configuration);
                            EntityId originatorId = BaseSchedulerEventService.getOriginatorId((SchedulerEvent)event);
                            boolean isFirmwareUpdate = "updateFirmware".equals(event.getType());
                            boolean isSoftwareUpdate = "updateSoftware".equals(event.getType());
                            if (isFirmwareUpdate || isSoftwareUpdate) {
                                OtaPackageId firmwareId = (OtaPackageId)JacksonUtil.convertValue((Object)configuration.get("msgBody"), OtaPackageId.class);
                                OtaPackageInfo firmwareInfo = this.otaPackageService.findOtaPackageInfoById(tenantId, firmwareId);
                                if (firmwareInfo == null) {
                                    throw new RuntimeException("Failed to process event: OtaPackage with id [" + String.valueOf(firmwareId) + "] not found!");
                                }
                                switch (2.$SwitchMap$org$thingsboard$server$common$data$EntityType[originatorId.getEntityType().ordinal()]) {
                                    case 1: {
                                        Device device = this.deviceService.findDeviceById(tenantId, (DeviceId)originatorId);
                                        if (device == null) {
                                            throw new RuntimeException("Failed to process event: Device with id [" + String.valueOf(originatorId) + "] not found!");
                                        }
                                        if (isFirmwareUpdate) {
                                            device.setFirmwareId(firmwareId);
                                        } else {
                                            device.setSoftwareId(firmwareId);
                                        }
                                        this.deviceService.saveDevice(device);
                                        break;
                                    }
                                    case 2: {
                                        EntityGroup deviceGroup = this.entityGroupService.findEntityGroupById(tenantId, (EntityGroupId)originatorId);
                                        if (deviceGroup == null) {
                                            throw new RuntimeException("Failed to process event: Device group with id [" + String.valueOf(originatorId) + "] not found!");
                                        }
                                        DeviceGroupOtaPackage oldDgf = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupIdAndType(deviceGroup.getId(), firmwareInfo.getType());
                                        DeviceGroupOtaPackage dgop = new DeviceGroupOtaPackage();
                                        dgop.setOtaPackageType(firmwareInfo.getType());
                                        dgop.setGroupId(deviceGroup.getId());
                                        dgop.setOtaPackageId(firmwareId);
                                        if (oldDgf != null) {
                                            dgop.setId(oldDgf.getId());
                                        }
                                        this.firmwareStateService.update(tenantId, this.deviceGroupOtaPackageService.saveDeviceGroupOtaPackage(tenantId, dgop), oldDgf);
                                        break;
                                    }
                                    case 3: {
                                        DeviceProfile deviceProfile = this.deviceProfileService.findDeviceProfileById(tenantId, (DeviceProfileId)originatorId);
                                        if (deviceProfile == null) {
                                            throw new RuntimeException("Failed to process event: Device profile with id [" + String.valueOf(originatorId) + "] not found!");
                                        }
                                        if (isFirmwareUpdate) {
                                            deviceProfile.setFirmwareId(firmwareId);
                                        } else {
                                            deviceProfile.setSoftwareId(firmwareId);
                                        }
                                        this.firmwareStateService.update(this.deviceProfileService.saveDeviceProfile(deviceProfile), isFirmwareUpdate, isSoftwareUpdate);
                                        break;
                                    }
                                    default: {
                                        throw new RuntimeException("Not implemented!");
                                    }
                                }
                            }
                            if ("generateReport".equals(event.getType())) {
                                ReportConfig reportConfig = (ReportConfig)JacksonUtil.treeToValue((JsonNode)configuration, ReportConfig.class);
                                Job job = Job.newReportJob().tenantId(tenantId).reportTemplateId(reportConfig.getReportTemplateId()).userId(reportConfig.getUserId()).timezone(reportConfig.getTimezone()).targets(reportConfig.getTargets()).notificationTemplateId(reportConfig.getNotificationTemplateId()).build();
                                ReportJobConfiguration jobConfig = (ReportJobConfiguration)job.getConfiguration();
                                jobConfig.setSchedulerEventInfo(new EntityInfo((EntityId)eventId, event.getName()));
                                this.jobManager.submitJob(job);
                            } else {
                                TbMsgMetaData tbMsgMD = this.getTbMsgMetaData(event, configuration);
                                TbMsg tbMsg = TbMsg.newMsg().type(msgType).originator(originatorId).metaData(tbMsgMD).dataType(TbMsgDataType.JSON).data(this.getMsgBody(event.getConfiguration())).build();
                                log.debug("pushing message to the rule engine tenant {}, originator {}, msg {}", new Object[]{tenantId, originatorId, tbMsg});
                                this.clusterService.pushMsgToRuleEngine(tenantId, originatorId, tbMsg, null);
                            }
                        }
                        catch (Exception e) {
                            log.error("[{}][{}] Failed to trigger event", new Object[]{event.getTenantId(), eventId, e});
                        }
                        this.scheduleNextEvent(System.currentTimeMillis(), (SchedulerEventInfo)event, md);
                        break block24;
                    }
                    log.debug("[{}] Triggered event is not present in the database.", (Object)eventId);
                    this.eventsMetaData.remove(eventId);
                }
                catch (Exception e) {
                    log.error("[{}] Failed to findSchedulerEventById. Retrying to re-process this event in a moment", (Object)eventId, (Object)e);
                    md.setNextTaskFuture(this.scheduledExecutor.schedule(() -> this.processEvent(tenantId, eventId), 1L, TimeUnit.MINUTES));
                }
            } else {
                log.debug("[{}] Triggered processing of removed event.", (Object)eventId);
            }
        }
    }

    private String getMsgBody(JsonNode configuration) throws JsonProcessingException {
        return JacksonUtil.toString((Object)configuration.get("msgBody"));
    }

    private String getMsgType(SchedulerEvent event, JsonNode configuration) {
        String msgType = configuration.has("msgType") && !configuration.get("msgType").isNull() ? configuration.get("msgType").asText() : event.getType();
        return msgType.equals("generateDashboardReport") ? TbMsgType.generateReport.name() : msgType;
    }

    private TbMsgMetaData getTbMsgMetaData(SchedulerEvent event, JsonNode configuration) throws JsonProcessingException {
        HashMap<String, String> metaData = new HashMap<String, String>();
        if (configuration.has("metadata") && !configuration.get("metadata").isNull()) {
            Iterator it = configuration.get("metadata").fields();
            while (it.hasNext()) {
                Map.Entry kv = (Map.Entry)it.next();
                metaData.put((String)kv.getKey(), ((JsonNode)kv.getValue()).asText());
            }
        } else {
            metaData.put("customerId", event.getCustomerId().getId().toString());
            metaData.put("eventName", event.getName());
            if (event.getAdditionalInfo() != null) {
                metaData.put("additionalInfo", JacksonUtil.toString((Object)event.getAdditionalInfo()));
            }
        }
        if ("sendRpcRequest".equals(event.getType())) {
            metaData.put("originServiceId", this.serviceId);
            if (metaData.get("timeout") != null) {
                metaData.put("expirationTime", String.valueOf(System.currentTimeMillis() + Math.max(this.minTimeout, Long.parseLong((String)metaData.get("timeout")))));
            }
        }
        return new TbMsgMetaData(metaData);
    }

    void onEventDeleted(SchedulerEventId eventId) {
        log.debug("onEventDeleted event {}", (Object)eventId);
        SchedulerEventMetaData oldMd = (SchedulerEventMetaData)this.eventsMetaData.remove(eventId);
        if (oldMd != null && oldMd.getNextTaskFuture() != null) {
            oldMd.getNextTaskFuture().cancel(false);
        }
    }

    private void scheduleAndAddToMap(SchedulerEventInfo event) {
        log.debug("scheduleAndAddToMap event {}", (Object)event);
        long ts = System.currentTimeMillis();
        SchedulerEventMetaData eventMd = this.getSchedulerEventMetaData(event);
        this.eventsMetaData.put(event.getId(), eventMd);
        this.scheduleNextEvent(ts, event, eventMd);
    }

    private void sendSchedulerEvent(TenantId tenantId, SchedulerEventId eventId, boolean added, boolean updated, boolean deleted) {
        log.trace("sendSchedulerEvent tenantId {}, eventId {}, added {}, updated {}, deleted {}", new Object[]{tenantId, eventId, added, updated, deleted});
        TransportProtos.SchedulerServiceMsgProto.Builder builder = TransportProtos.SchedulerServiceMsgProto.newBuilder();
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        builder.setEventIdMSB(eventId.getId().getMostSignificantBits());
        builder.setEventIdLSB(eventId.getId().getLeastSignificantBits());
        builder.setAdded(added);
        builder.setUpdated(updated);
        builder.setDeleted(deleted);
        TransportProtos.SchedulerServiceMsgProto msg = builder.build();
        log.trace("msg {}", (Object)msg);
        TransportProtos.ToCoreMsg toCoreMsg = TransportProtos.ToCoreMsg.newBuilder().setSchedulerServiceMsg(msg).build();
        log.trace("toCoreMsg.hasSchedulerServiceMsg() {} toCoreMsg {}", (Object)toCoreMsg.hasSchedulerServiceMsg(), (Object)toCoreMsg);
        this.clusterService.pushMsgToCore(tenantId, (EntityId)tenantId, toCoreMsg, (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @ConstructorProperties(value={"tenantService", "clusterService", "partitionService", "schedulerEventService", "firmwareStateService", "deviceService", "deviceProfileService", "entityGroupService", "deviceGroupOtaPackageService", "otaPackageService", "serviceInfoProvider", "jobManager"})
    @Generated
    public DefaultSchedulerService(TenantService tenantService, TbClusterService clusterService, PartitionService partitionService, SchedulerEventService schedulerEventService, OtaPackageStateService firmwareStateService, DeviceService deviceService, DeviceProfileService deviceProfileService, EntityGroupService entityGroupService, DeviceGroupOtaPackageService deviceGroupOtaPackageService, OtaPackageService otaPackageService, TbServiceInfoProvider serviceInfoProvider, JobManager jobManager) {
        this.tenantService = tenantService;
        this.clusterService = clusterService;
        this.partitionService = partitionService;
        this.schedulerEventService = schedulerEventService;
        this.firmwareStateService = firmwareStateService;
        this.deviceService = deviceService;
        this.deviceProfileService = deviceProfileService;
        this.entityGroupService = entityGroupService;
        this.deviceGroupOtaPackageService = deviceGroupOtaPackageService;
        this.otaPackageService = otaPackageService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.jobManager = jobManager;
    }
}

