/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ruleengine;

import com.google.protobuf.ByteString;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.gen.MsgProtos;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.ruleengine.RuleEngineCallService;

@Service
public class DefaultRuleEngineCallService
implements RuleEngineCallService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRuleEngineCallService.class);
    private final TbClusterService clusterService;
    private ScheduledExecutorService executor;
    private final ConcurrentMap<UUID, Consumer<TbMsg>> requests = new ConcurrentHashMap();

    public DefaultRuleEngineCallService(TbClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @PostConstruct
    public void initExecutor() {
        this.executor = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"re-rest-callback");
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void processRestApiCallToRuleEngine(TenantId tenantId, UUID requestId, TbMsg request, boolean useQueueFromTbMsg, Consumer<TbMsg> responseConsumer) {
        log.trace("[{}] Processing REST API call to rule engine: [{}] for entity: [{}]", new Object[]{tenantId, requestId, request.getOriginator()});
        this.requests.put(requestId, responseConsumer);
        this.sendRequestToRuleEngine(tenantId, request, useQueueFromTbMsg);
        this.scheduleTimeout(request, requestId, this.requests);
    }

    public void onQueueMsg(TransportProtos.RestApiCallResponseMsgProto restApiCallResponseMsg, TbCallback callback) {
        UUID requestId = new UUID(restApiCallResponseMsg.getRequestIdMSB(), restApiCallResponseMsg.getRequestIdLSB());
        Consumer consumer = (Consumer)this.requests.remove(requestId);
        if (consumer != null) {
            consumer.accept(TbMsg.fromProto(null, (MsgProtos.TbMsgProto)restApiCallResponseMsg.getResponseProto(), (ByteString)restApiCallResponseMsg.getResponse(), (TbMsgCallback)TbMsgCallback.EMPTY));
        } else {
            log.trace("[{}] Unknown or stale rest api call response received", (Object)requestId);
        }
        callback.onSuccess();
    }

    private void sendRequestToRuleEngine(TenantId tenantId, TbMsg msg, boolean useQueueFromTbMsg) {
        this.clusterService.pushMsgToRuleEngine(tenantId, msg.getOriginator(), msg, useQueueFromTbMsg, null);
    }

    private void scheduleTimeout(TbMsg request, UUID requestId, ConcurrentMap<UUID, Consumer<TbMsg>> requestsMap) {
        long expirationTime = Long.parseLong(request.getMetaData().getValue("expirationTime"));
        long timeout = Math.max(0L, expirationTime - System.currentTimeMillis());
        log.trace("[{}] processing the request: [{}]", (Object)this.hashCode(), (Object)requestId);
        this.executor.schedule(() -> {
            Consumer consumer = (Consumer)requestsMap.remove(requestId);
            if (consumer != null) {
                log.trace("[{}] request timeout detected: [{}]", (Object)this.hashCode(), (Object)requestId);
                consumer.accept(null);
            }
        }, timeout, TimeUnit.MILLISECONDS);
    }
}

