/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.report;

import com.google.protobuf.InvalidProtocolBufferException;
import java.beans.ConstructorProperties;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ApiUsageLimitsExceededException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.ReportId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.JobStatus;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.job.ReportJobConfiguration;
import org.thingsboard.server.common.data.job.ReportJobResult;
import org.thingsboard.server.common.data.job.task.ReportTask;
import org.thingsboard.server.common.data.job.task.ReportTaskResult;
import org.thingsboard.server.common.data.job.task.Task;
import org.thingsboard.server.common.data.job.task.TaskResult;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestConfig;
import org.thingsboard.server.common.data.notification.NotificationRequestStats;
import org.thingsboard.server.common.data.notification.NotificationRequestStatus;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.notification.info.ReportGeneratedNotificationInfo;
import org.thingsboard.server.common.data.report.Report;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.gen.MsgProtos;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.dao.notification.NotificationRequestService;
import org.thingsboard.server.dao.report.ReportTemplateService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.common.SimpleTbQueueCallback;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.executors.NotificationExecutorService;
import org.thingsboard.server.service.job.JobProcessor;
import org.thingsboard.server.service.security.model.token.AccessJwtToken;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@Component
public class ReportJobProcessor
implements JobProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportJobProcessor.class);
    public static final String REPORT_CREATION_DISABLED = "Report creation is disabled";
    private final ReportTemplateService reportTemplateService;
    private final SystemSecurityService systemSecurityService;
    @Lazy
    private final NotificationCenter notificationCenter;
    private final NotificationRequestService notificationRequestService;
    private final NotificationExecutorService notificationExecutor;
    private final TbClusterService clusterService;
    private final PartitionService partitionService;
    private final OwnersCacheService ownersCacheService;
    @Lazy
    private final ActorSystemContext actorSystemContext;
    private final TbApiUsageStateService apiUsageStateService;
    private final TbApiUsageReportClient apiUsageClient;
    private final UserService userService;

    public int process(Job job, Consumer<Task<?>> taskConsumer) throws Exception {
        ReportJobConfiguration configuration = (ReportJobConfiguration)job.getConfiguration();
        if (configuration.getReportTemplateId() == null) {
            throw new IllegalArgumentException("Report template must be specified");
        }
        boolean creationEnabled = this.apiUsageStateService.getApiUsageState(job.getTenantId()).isReportCreationEnabled();
        if (!creationEnabled) {
            throw new ApiUsageLimitsExceededException(REPORT_CREATION_DISABLED);
        }
        ReportTemplate reportTemplate = this.reportTemplateService.findReportTemplateById(job.getTenantId(), configuration.getReportTemplateId());
        User user = this.userService.findUserById(job.getTenantId(), configuration.getUserId());
        AccessJwtToken accessToken = this.systemSecurityService.createUserAccessToken(job.getTenantId(), configuration.getUserId());
        EntityId userOwnerId = this.ownersCacheService.getOwner(job.getTenantId(), (EntityId)configuration.getUserId());
        ReportTask task = ((ReportTask.ReportTaskBuilder)((ReportTask.ReportTaskBuilder)((ReportTask.ReportTaskBuilder)ReportTask.builder().tenantId(job.getTenantId())).customerId(user.getCustomerId()).jobId((JobId)job.getId())).key(configuration.getTasksKey())).reportTemplateId(reportTemplate.getId()).reportTemplateConfig(reportTemplate.getConfiguration()).timezone(configuration.getTimezone()).userId(configuration.getUserId()).userOwnerId(userOwnerId).originator(configuration.getOriginator()).accessToken(accessToken.getToken()).accessTokenExpirationTs(accessToken.getClaims().getExpiration().getTime()).build();
        taskConsumer.accept((Task<?>)task);
        return 1;
    }

    public void reprocess(Job job, List<TaskResult> failures, Consumer<Task<?>> taskConsumer) throws Exception {
        this.process(job, taskConsumer);
    }

    public void onJobFinished(Job job) {
        ReportJobResult result = (ReportJobResult)job.getResult();
        ReportJobConfiguration configuration = (ReportJobConfiguration)job.getConfiguration();
        TenantId tenantId = job.getTenantId();
        if (configuration.getOutputTbMsgProto() != null) {
            try {
                this.produceOutputMsg(tenantId, configuration, result);
            }
            catch (Exception e) {
                log.error("[{}] Failed to produce rule engine output msg for job {}", new Object[]{tenantId, job.getId(), e});
            }
        }
        if (job.getStatus() == JobStatus.COMPLETED) {
            this.apiUsageClient.report(job.getTenantId(), null, ApiUsageRecordKey.GENERATED_REPORTS_COUNT);
            Report report = result.getReport();
            if (CollectionsUtil.isNotEmpty((Collection)configuration.getTargets()) && configuration.getNotificationTemplateId() != null) {
                NotificationRequest notificationRequest2 = NotificationRequest.builder().tenantId(tenantId).targets(configuration.getTargets()).templateId(configuration.getNotificationTemplateId()).originatorEntityId((EntityId)report.getUserId()).info((NotificationInfo)ReportGeneratedNotificationInfo.builder().tenantId(tenantId).customerId(report.getCustomerId()).reportFormat(report.getFormat()).reportName(report.getName()).userId(report.getUserId()).build()).build();
                this.processNotification(notificationRequest2, report);
            } else if (configuration.getNotificationRequests() != null) {
                configuration.getNotificationRequests().forEach(notificationRequest -> this.processNotification(notificationRequest, report));
            }
        } else if (configuration.getNotificationRequests() != null) {
            RuntimeException error = new RuntimeException("Failed to generate report: " + this.getError(result));
            configuration.getNotificationRequests().forEach(notificationRequest -> {
                NotificationRequestStats stats = notificationRequest.getStats();
                if (stats == null) {
                    stats = new NotificationRequestStats();
                }
                stats.reportGeneralError((Throwable)error);
                this.notificationRequestService.updateNotificationRequest(tenantId, (NotificationRequestId)notificationRequest.getId(), NotificationRequestStatus.SENT, stats);
            });
        }
    }

    private void processNotification(NotificationRequest notificationRequest, Report report) {
        TenantId tenantId = report.getTenantId();
        NotificationRequestConfig requestConfig = notificationRequest.getAdditionalConfig() != null ? notificationRequest.getAdditionalConfig() : new NotificationRequestConfig();
        requestConfig.setReports(List.of((ReportId)report.getId()));
        notificationRequest.setAdditionalConfig(requestConfig);
        log.debug("Submitting notification request with report: {}", (Object)notificationRequest);
        this.notificationExecutor.executeAsync(() -> {
            try {
                this.notificationCenter.processNotificationRequest(tenantId, notificationRequest, null);
            }
            catch (Exception e) {
                log.error("[{}] Failed to process notification request: {}", new Object[]{tenantId, notificationRequest, e});
            }
        });
    }

    private void produceOutputMsg(TenantId tenantId, ReportJobConfiguration configuration, ReportJobResult result) {
        String relationType;
        TbMsg outputMsg;
        try {
            outputMsg = TbMsg.fromProto((String)configuration.getQueueName(), (MsgProtos.TbMsgProto)MsgProtos.TbMsgProto.parseFrom((byte[])Base64.getDecoder().decode(configuration.getOutputTbMsgProto())), null);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        String error = this.getError(result);
        if (error != null) {
            relationType = "Failure";
        } else {
            relationType = "Success";
            outputMsg.getMetaData().putValue("reports", ((ReportId)result.getReport().getId()).toString());
        }
        TransportProtos.ToRuleEngineMsg.Builder ruleEngineMsg = TransportProtos.ToRuleEngineMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setTbMsgProto(TbMsg.toProto((TbMsg)outputMsg)).addRelationTypes(relationType);
        if (error != null) {
            ruleEngineMsg.setFailureMessage(error);
        }
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_RULE_ENGINE, outputMsg.getQueueName(), tenantId, outputMsg.getOriginator());
        this.clusterService.pushMsgToRuleEngine(tpi, outputMsg.getId(), ruleEngineMsg.build(), (TbQueueCallback)new SimpleTbQueueCallback(tbQueueMsgMetadata -> this.actorSystemContext.persistDebugOutputIfNeeded(tenantId, configuration.getRuleNode(), outputMsg, Set.of(relationType), null, error), throwable -> log.error("[{}] Failed to send msg {}", new Object[]{tenantId, ruleEngineMsg, throwable})));
    }

    private String getError(ReportJobResult result) {
        if (result.getCancellationTs() > 0L) {
            return "The task was cancelled";
        }
        if (result.getGeneralError() != null) {
            return result.getGeneralError();
        }
        if (result.getFailedCount() > 0) {
            return result.getResults().stream().filter(Predicate.not(TaskResult::isSuccess)).findFirst().map(taskResult -> ((ReportTaskResult)taskResult).getError()).orElse(null);
        }
        return null;
    }

    public JobType getType() {
        return JobType.REPORT;
    }

    @ConstructorProperties(value={"reportTemplateService", "systemSecurityService", "notificationCenter", "notificationRequestService", "notificationExecutor", "clusterService", "partitionService", "ownersCacheService", "actorSystemContext", "apiUsageStateService", "apiUsageClient", "userService"})
    @Generated
    public ReportJobProcessor(ReportTemplateService reportTemplateService, SystemSecurityService systemSecurityService, @Lazy NotificationCenter notificationCenter, NotificationRequestService notificationRequestService, NotificationExecutorService notificationExecutor, TbClusterService clusterService, PartitionService partitionService, OwnersCacheService ownersCacheService, @Lazy ActorSystemContext actorSystemContext, TbApiUsageStateService apiUsageStateService, TbApiUsageReportClient apiUsageClient, UserService userService) {
        this.reportTemplateService = reportTemplateService;
        this.systemSecurityService = systemSecurityService;
        this.notificationCenter = notificationCenter;
        this.notificationRequestService = notificationRequestService;
        this.notificationExecutor = notificationExecutor;
        this.clusterService = clusterService;
        this.partitionService = partitionService;
        this.ownersCacheService = ownersCacheService;
        this.actorSystemContext = actorSystemContext;
        this.apiUsageStateService = apiUsageStateService;
        this.apiUsageClient = apiUsageClient;
        this.userService = userService;
    }
}

