/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue.processing;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.service.queue.TbMsgPackProcessingContext;

public class TbRuleEngineProcessingResult {
    private final String queueName;
    private final boolean success;
    private final boolean timeout;
    private final TbMsgPackProcessingContext ctx;

    public TbRuleEngineProcessingResult(String queueName, boolean timeout, TbMsgPackProcessingContext ctx) {
        this.queueName = queueName;
        this.timeout = timeout;
        this.ctx = ctx;
        this.success = !timeout && ctx.getPendingMap().isEmpty() && ctx.getFailedMap().isEmpty();
    }

    public ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getPendingMap() {
        return this.ctx.getPendingMap();
    }

    public ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getSuccessMap() {
        return this.ctx.getSuccessMap();
    }

    public ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getFailedMap() {
        return this.ctx.getFailedMap();
    }

    public ConcurrentMap<TenantId, RuleEngineException> getExceptionsMap() {
        return this.ctx.getExceptionsMap();
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public boolean isTimeout() {
        return this.timeout;
    }

    @Generated
    public TbMsgPackProcessingContext getCtx() {
        return this.ctx;
    }
}

