/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue.processing;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.service.queue.processing.AbstractTbRuleEngineSubmitStrategy;
import org.thingsboard.server.service.queue.processing.IdMsgPair;

public class SequentialTbRuleEngineSubmitStrategy
extends AbstractTbRuleEngineSubmitStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequentialTbRuleEngineSubmitStrategy.class);
    private final AtomicInteger msgIdx = new AtomicInteger(0);
    private volatile BiConsumer<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> msgConsumer;
    private volatile UUID expectedMsgId;

    public SequentialTbRuleEngineSubmitStrategy(String queueName) {
        super(queueName);
    }

    public void submitAttempt(BiConsumer<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> msgConsumer) {
        this.msgConsumer = msgConsumer;
        this.msgIdx.set(0);
        this.submitNext();
    }

    public void update(ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> reprocessMap) {
        super.update(reprocessMap);
    }

    protected void doOnSuccess(UUID id) {
        if (this.expectedMsgId.equals(id)) {
            this.msgIdx.incrementAndGet();
            this.submitNext();
        }
    }

    private void submitNext() {
        int listSize = this.orderedMsgList.size();
        int idx = this.msgIdx.get();
        if (idx < listSize) {
            IdMsgPair pair = (IdMsgPair)this.orderedMsgList.get(idx);
            this.expectedMsgId = pair.uuid;
            if (log.isDebugEnabled()) {
                log.debug("[{}] submitting [{}] message to rule engine", (Object)this.queueName, (Object)pair.msg);
            }
            this.msgConsumer.accept(pair.uuid, pair.msg);
        }
    }
}

