/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue.processing;

import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.dao.resource.TbResourceDataCache;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.QueueConsumerManager;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbPackCallback;
import org.thingsboard.server.queue.util.TbPackProcessingContext;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.queue.processing.IdMsgPair;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;

public abstract class AbstractConsumerService<N extends GeneratedMessageV3>
extends TbApplicationEventListener<PartitionChangeEvent> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ActorSystemContext actorContext;
    protected final TbTenantProfileCache tenantProfileCache;
    protected final TbDeviceProfileCache deviceProfileCache;
    protected final TbAssetProfileCache assetProfileCache;
    protected final TbResourceDataCache tbResourceDataCache;
    protected final CalculatedFieldCache calculatedFieldCache;
    protected final TbApiUsageStateService apiUsageStateService;
    protected final PartitionService partitionService;
    protected final ApplicationEventPublisher eventPublisher;
    protected final JwtSettingsService jwtSettingsService;
    protected QueueConsumerManager<TbProtoQueueMsg<N>> nfConsumer;
    protected ExecutorService consumersExecutor;
    protected ExecutorService mgmtExecutor;
    protected ScheduledExecutorService scheduler;

    public void init(String prefix) {
        this.consumersExecutor = Executors.newCachedThreadPool((ThreadFactory)ThingsBoardThreadFactory.forName((String)(prefix + "-consumer")));
        this.mgmtExecutor = ThingsBoardExecutors.newWorkStealingPool((int)this.getMgmtThreadPoolSize(), (String)(prefix + "-mgmt"));
        this.scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)(prefix + "-consumer-scheduler"));
        this.nfConsumer = QueueConsumerManager.builder().name(this.getServiceType().getLabel() + " Notifications").msgPackProcessor((arg_0, arg_1) -> this.processNotifications(arg_0, arg_1)).pollInterval(this.getNotificationPollDuration()).consumerCreator(() -> this.createNotificationsConsumer()).consumerExecutor(this.consumersExecutor).threadPrefix("notifications").build();
    }

    @AfterStartUp(order=11)
    public void afterStartUp() {
        this.startConsumers();
    }

    protected void startConsumers() {
        this.nfConsumer.subscribe();
        this.nfConsumer.launch();
    }

    protected boolean filterTbApplicationEvent(PartitionChangeEvent event) {
        return event.getServiceType() == this.getServiceType();
    }

    protected abstract ServiceType getServiceType();

    protected void stopConsumers() {
        this.nfConsumer.stop();
    }

    protected abstract long getNotificationPollDuration();

    protected abstract long getNotificationPackProcessingTimeout();

    protected abstract int getMgmtThreadPoolSize();

    protected abstract TbQueueConsumer<TbProtoQueueMsg<N>> createNotificationsConsumer();

    protected void processNotifications(List<TbProtoQueueMsg<N>> msgs, TbQueueConsumer<TbProtoQueueMsg<N>> consumer) throws Exception {
        List<IdMsgPair> orderedMsgList = msgs.stream().map(msg -> new IdMsgPair(UUID.randomUUID(), msg)).toList();
        ConcurrentMap<UUID, TbProtoQueueMsg> pendingMap = orderedMsgList.stream().collect(Collectors.toConcurrentMap(IdMsgPair::getUuid, IdMsgPair::getMsg));
        CountDownLatch processingTimeoutLatch = new CountDownLatch(1);
        TbPackProcessingContext ctx = new TbPackProcessingContext(processingTimeoutLatch, pendingMap, new ConcurrentHashMap());
        orderedMsgList.forEach(element -> {
            UUID id = element.getUuid();
            TbProtoQueueMsg msg = element.getMsg();
            this.log.trace("[{}] Creating notification callback for message: {}", (Object)id, (Object)msg.getValue());
            TbPackCallback callback = new TbPackCallback(id, ctx);
            try {
                this.handleNotification(id, msg, (TbCallback)callback);
            }
            catch (Throwable e) {
                this.log.warn("[{}] Failed to process notification: {}", new Object[]{id, msg, e});
                callback.onFailure(e);
            }
        });
        if (!processingTimeoutLatch.await(this.getNotificationPackProcessingTimeout(), TimeUnit.MILLISECONDS)) {
            ctx.getAckMap().forEach((id, msg) -> this.log.warn("[{}] Timeout to process notification: {}", id, (Object)msg.getValue()));
            ctx.getFailedMap().forEach((id, msg) -> this.log.warn("[{}] Failed to process notification: {}", id, (Object)msg.getValue()));
        }
        consumer.commit();
    }

    protected final void handleComponentLifecycleMsg(UUID id, ComponentLifecycleMsg componentLifecycleMsg) {
        TenantId tenantId = componentLifecycleMsg.getTenantId();
        this.log.debug("[{}][{}][{}] Received Lifecycle event: {}", new Object[]{tenantId, componentLifecycleMsg.getEntityId().getEntityType(), componentLifecycleMsg.getEntityId(), componentLifecycleMsg.getEvent()});
        if (EntityType.TENANT_PROFILE.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            TenantProfileId tenantProfileId = new TenantProfileId(componentLifecycleMsg.getEntityId().getId());
            this.tenantProfileCache.evict(tenantProfileId);
            if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.UPDATED)) {
                this.apiUsageStateService.onTenantProfileUpdate(tenantProfileId);
                this.calculatedFieldCache.handleTenantProfileUpdate(tenantProfileId);
            }
        } else if (EntityType.TENANT.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            if (TenantId.SYS_TENANT_ID.equals((Object)tenantId)) {
                this.jwtSettingsService.reloadJwtSettings();
                return;
            }
            this.tenantProfileCache.evict(tenantId);
            this.partitionService.evictTenantInfo(tenantId);
            if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.UPDATED)) {
                this.apiUsageStateService.onTenantUpdate(tenantId);
            } else if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.DELETED)) {
                this.apiUsageStateService.onTenantDelete(tenantId);
                this.calculatedFieldCache.evictOwner((EntityId)tenantId);
                this.partitionService.removeTenant(tenantId);
            }
        } else if (EntityType.DEVICE_PROFILE.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            this.deviceProfileCache.evict(tenantId, new DeviceProfileId(componentLifecycleMsg.getEntityId().getId()));
        } else if (EntityType.DEVICE.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            this.deviceProfileCache.evict(tenantId, new DeviceId(componentLifecycleMsg.getEntityId().getId()));
            if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.CREATED)) {
                this.calculatedFieldCache.addOwnerEntity(tenantId, componentLifecycleMsg.getEntityId());
            } else if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.UPDATED) && componentLifecycleMsg.isOwnerChanged()) {
                this.calculatedFieldCache.updateOwnerEntity(tenantId, componentLifecycleMsg.getEntityId());
            } else if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.DELETED)) {
                this.calculatedFieldCache.evictEntity(componentLifecycleMsg.getEntityId());
            }
        } else if (EntityType.ASSET_PROFILE.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            this.assetProfileCache.evict(tenantId, new AssetProfileId(componentLifecycleMsg.getEntityId().getId()));
        } else if (EntityType.ASSET.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            this.assetProfileCache.evict(tenantId, new AssetId(componentLifecycleMsg.getEntityId().getId()));
            if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.CREATED)) {
                this.calculatedFieldCache.addOwnerEntity(tenantId, componentLifecycleMsg.getEntityId());
            } else if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.UPDATED) && componentLifecycleMsg.isOwnerChanged()) {
                this.calculatedFieldCache.updateOwnerEntity(tenantId, componentLifecycleMsg.getEntityId());
            } else if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.DELETED)) {
                this.calculatedFieldCache.evictEntity(componentLifecycleMsg.getEntityId());
            }
        } else if (EntityType.ENTITY_VIEW.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            this.actorContext.getTbEntityViewService().onComponentLifecycleMsg(componentLifecycleMsg);
        } else if (EntityType.API_USAGE_STATE.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            this.apiUsageStateService.onApiUsageStateUpdate(tenantId);
        } else if (EntityType.CUSTOMER.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.CREATED)) {
                this.calculatedFieldCache.addOwnerEntity(tenantId, componentLifecycleMsg.getEntityId());
            } else if (componentLifecycleMsg.getEvent().equals((Object)ComponentLifecycleEvent.UPDATED) && componentLifecycleMsg.isOwnerChanged()) {
                this.calculatedFieldCache.updateOwnerEntity(tenantId, componentLifecycleMsg.getEntityId());
            } else if (componentLifecycleMsg.getEvent() == ComponentLifecycleEvent.DELETED) {
                this.apiUsageStateService.onCustomerDelete((CustomerId)componentLifecycleMsg.getEntityId());
                this.calculatedFieldCache.evictOwner(componentLifecycleMsg.getEntityId());
                this.calculatedFieldCache.evictEntity(componentLifecycleMsg.getEntityId());
            }
        } else if (EntityType.CALCULATED_FIELD.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            if (componentLifecycleMsg.getEvent() == ComponentLifecycleEvent.CREATED) {
                this.calculatedFieldCache.addCalculatedField(tenantId, (CalculatedFieldId)componentLifecycleMsg.getEntityId());
            } else if (componentLifecycleMsg.getEvent() == ComponentLifecycleEvent.UPDATED) {
                this.calculatedFieldCache.updateCalculatedField(tenantId, (CalculatedFieldId)componentLifecycleMsg.getEntityId());
            } else {
                this.calculatedFieldCache.evict((CalculatedFieldId)componentLifecycleMsg.getEntityId());
            }
        } else if (EntityType.TB_RESOURCE.equals((Object)componentLifecycleMsg.getEntityId().getEntityType())) {
            this.tbResourceDataCache.evictResourceData(tenantId, new TbResourceId(componentLifecycleMsg.getEntityId().getId()));
            return;
        }
        this.eventPublisher.publishEvent((Object)componentLifecycleMsg);
        this.log.trace("[{}] Forwarding component lifecycle message to App Actor {}", (Object)id, (Object)componentLifecycleMsg);
        this.actorContext.tellWithHighPriority((TbActorMsg)componentLifecycleMsg);
    }

    protected abstract void handleNotification(UUID var1, TbProtoQueueMsg<N> var2, TbCallback var3) throws Exception;

    @PreDestroy
    public void destroy() {
        this.stopConsumers();
        if (this.consumersExecutor != null) {
            this.consumersExecutor.shutdownNow();
        }
        if (this.mgmtExecutor != null) {
            this.mgmtExecutor.shutdownNow();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    @ConstructorProperties(value={"actorContext", "tenantProfileCache", "deviceProfileCache", "assetProfileCache", "tbResourceDataCache", "calculatedFieldCache", "apiUsageStateService", "partitionService", "eventPublisher", "jwtSettingsService"})
    @Generated
    public AbstractConsumerService(ActorSystemContext actorContext, TbTenantProfileCache tenantProfileCache, TbDeviceProfileCache deviceProfileCache, TbAssetProfileCache assetProfileCache, TbResourceDataCache tbResourceDataCache, CalculatedFieldCache calculatedFieldCache, TbApiUsageStateService apiUsageStateService, PartitionService partitionService, ApplicationEventPublisher eventPublisher, JwtSettingsService jwtSettingsService) {
        this.actorContext = actorContext;
        this.tenantProfileCache = tenantProfileCache;
        this.deviceProfileCache = deviceProfileCache;
        this.assetProfileCache = assetProfileCache;
        this.tbResourceDataCache = tbResourceDataCache;
        this.calculatedFieldCache = calculatedFieldCache;
        this.apiUsageStateService = apiUsageStateService;
        this.partitionService = partitionService;
        this.eventPublisher = eventPublisher;
        this.jwtSettingsService = jwtSettingsService;
    }
}

