/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.thingsboard.server.common.msg.queue.RuleNodeInfo;

public class TbRuleNodeProfilerInfo {
    private final UUID ruleNodeId;
    private final String label;
    private AtomicInteger executionCount = new AtomicInteger(0);
    private AtomicLong executionTime = new AtomicLong(0L);
    private AtomicLong maxExecutionTime = new AtomicLong(0L);

    public TbRuleNodeProfilerInfo(RuleNodeInfo ruleNodeInfo) {
        this.ruleNodeId = ruleNodeInfo.getRuleNodeId().getId();
        this.label = ruleNodeInfo.toString();
    }

    public TbRuleNodeProfilerInfo(UUID ruleNodeId) {
        this.ruleNodeId = ruleNodeId;
        this.label = "";
    }

    public void record(long processingTime) {
        long value;
        this.executionCount.incrementAndGet();
        this.executionTime.addAndGet(processingTime);
        while ((value = this.maxExecutionTime.get()) < processingTime && !this.maxExecutionTime.compareAndSet(value, processingTime)) {
        }
    }

    int getExecutionCount() {
        return this.executionCount.get();
    }

    long getMaxExecutionTime() {
        return this.maxExecutionTime.get();
    }

    double getAvgExecutionTime() {
        double executionCnt = this.executionCount.get();
        if (executionCnt > 0.0) {
            return (double)this.executionTime.get() / executionCnt;
        }
        return 0.0;
    }

    @Generated
    public UUID getRuleNodeId() {
        return this.ruleNodeId;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }
}

