/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.RuleNodeInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.service.queue.TbMsgProfilerInfo;
import org.thingsboard.server.service.queue.TbRuleNodeProfilerInfo;
import org.thingsboard.server.service.queue.processing.TbRuleEngineSubmitStrategy;

public class TbMsgPackProcessingContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbMsgPackProcessingContext.class);
    private final String queueName;
    private final TbRuleEngineSubmitStrategy submitStrategy;
    private final boolean skipTimeoutMsgsPossible;
    private final boolean profilerEnabled;
    private final AtomicInteger pendingCount;
    private final CountDownLatch processingTimeoutLatch = new CountDownLatch(1);
    private final ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> pendingMap;
    private final ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> successMap = new ConcurrentHashMap();
    private final ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> failedMap = new ConcurrentHashMap();
    private final ConcurrentMap<TenantId, RuleEngineException> exceptionsMap = new ConcurrentHashMap();
    private final ConcurrentMap<UUID, RuleNodeInfo> lastRuleNodeMap = new ConcurrentHashMap();
    private volatile boolean canceled = false;
    private final ConcurrentHashMap<UUID, TbMsgProfilerInfo> msgProfilerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, TbRuleNodeProfilerInfo> ruleNodeProfilerMap = new ConcurrentHashMap();

    public TbMsgPackProcessingContext(String queueName, TbRuleEngineSubmitStrategy submitStrategy, boolean skipTimeoutMsgsPossible) {
        this.queueName = queueName;
        this.submitStrategy = submitStrategy;
        this.skipTimeoutMsgsPossible = skipTimeoutMsgsPossible;
        this.profilerEnabled = log.isDebugEnabled();
        this.pendingMap = submitStrategy.getPendingMap();
        this.pendingCount = new AtomicInteger(this.pendingMap.size());
    }

    public boolean await(long packProcessingTimeout, TimeUnit milliseconds) throws InterruptedException {
        boolean success = this.processingTimeoutLatch.await(packProcessingTimeout, milliseconds);
        if (!success && this.profilerEnabled) {
            this.msgProfilerMap.values().forEach(arg_0 -> this.onTimeout(arg_0));
        }
        return success;
    }

    public void onSuccess(UUID id) {
        boolean empty = false;
        TbProtoQueueMsg msg = (TbProtoQueueMsg)this.pendingMap.remove(id);
        if (msg != null) {
            empty = this.pendingCount.decrementAndGet() == 0;
            this.successMap.put(id, msg);
            this.submitStrategy.onSuccess(id);
        }
        if (empty) {
            this.processingTimeoutLatch.countDown();
        }
    }

    public void onFailure(TenantId tenantId, UUID id, RuleEngineException e) {
        boolean empty = false;
        TbProtoQueueMsg msg = (TbProtoQueueMsg)this.pendingMap.remove(id);
        if (msg != null) {
            empty = this.pendingCount.decrementAndGet() == 0;
            this.failedMap.put(id, msg);
            this.exceptionsMap.putIfAbsent(tenantId, e);
        }
        if (empty) {
            this.processingTimeoutLatch.countDown();
        }
    }

    public void onProcessingStart(UUID id, RuleNodeInfo ruleNodeInfo) {
        this.lastRuleNodeMap.put(id, ruleNodeInfo);
        if (this.profilerEnabled) {
            this.msgProfilerMap.computeIfAbsent(id, TbMsgProfilerInfo::new).onStart(ruleNodeInfo.getRuleNodeId());
            this.ruleNodeProfilerMap.putIfAbsent(ruleNodeInfo.getRuleNodeId().getId(), new TbRuleNodeProfilerInfo(ruleNodeInfo));
        }
    }

    public void onProcessingEnd(UUID id, RuleNodeId ruleNodeId) {
        long processingTime;
        if (this.profilerEnabled && (processingTime = this.msgProfilerMap.computeIfAbsent(id, TbMsgProfilerInfo::new).onEnd(ruleNodeId)) > 0L) {
            this.ruleNodeProfilerMap.computeIfAbsent(ruleNodeId.getId(), TbRuleNodeProfilerInfo::new).record(processingTime);
        }
    }

    public void onTimeout(TbMsgProfilerInfo profilerInfo) {
        Map.Entry ruleNodeInfo = profilerInfo.onTimeout();
        if (ruleNodeInfo != null) {
            this.ruleNodeProfilerMap.computeIfAbsent((UUID)ruleNodeInfo.getKey(), TbRuleNodeProfilerInfo::new).record(((Long)ruleNodeInfo.getValue()).longValue());
        }
    }

    public RuleNodeInfo getLastVisitedRuleNode(UUID id) {
        return (RuleNodeInfo)this.lastRuleNodeMap.get(id);
    }

    public void printProfilerStats() {
        if (this.profilerEnabled) {
            log.debug("Top Rule Nodes by max execution time:");
            this.ruleNodeProfilerMap.values().stream().sorted(Comparator.comparingLong(TbRuleNodeProfilerInfo::getMaxExecutionTime).reversed()).limit(5L).forEach(info -> log.debug("[{}][{}] max execution time: {}. {}", new Object[]{this.queueName, info.getRuleNodeId(), info.getMaxExecutionTime(), info.getLabel()}));
            log.info("Top Rule Nodes by avg execution time:");
            this.ruleNodeProfilerMap.values().stream().sorted(Comparator.comparingDouble(TbRuleNodeProfilerInfo::getAvgExecutionTime).reversed()).limit(5L).forEach(info -> log.info("[{}][{}] avg execution time: {}. {}", new Object[]{this.queueName, info.getRuleNodeId(), info.getAvgExecutionTime(), info.getLabel()}));
            log.info("Top Rule Nodes by execution count:");
            this.ruleNodeProfilerMap.values().stream().sorted(Comparator.comparingInt(TbRuleNodeProfilerInfo::getExecutionCount).reversed()).limit(5L).forEach(info -> log.info("[{}][{}] execution count: {}. {}", new Object[]{this.queueName, info.getRuleNodeId(), info.getExecutionCount(), info.getLabel()}));
        }
    }

    public void cleanup() {
        this.canceled = true;
        this.pendingMap.clear();
        this.successMap.clear();
        this.failedMap.clear();
    }

    public boolean isCanceled() {
        return this.skipTimeoutMsgsPossible && this.canceled;
    }

    @Generated
    public boolean isProfilerEnabled() {
        return this.profilerEnabled;
    }

    @Generated
    public ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getPendingMap() {
        return this.pendingMap;
    }

    @Generated
    public ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getSuccessMap() {
        return this.successMap;
    }

    @Generated
    public ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getFailedMap() {
        return this.failedMap;
    }

    @Generated
    public ConcurrentMap<TenantId, RuleEngineException> getExceptionsMap() {
        return this.exceptionsMap;
    }
}

