/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import io.micrometer.core.instrument.Timer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ExceptionUtil;
import org.thingsboard.server.common.data.exception.AbstractRateLimitException;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.RuleNodeInfo;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.service.queue.TbMsgPackProcessingContext;

public class TbMsgPackCallback
implements TbMsgCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbMsgPackCallback.class);
    private final UUID id;
    private final TenantId tenantId;
    private final TbMsgPackProcessingContext ctx;
    private final long startMsgProcessing;
    private final Timer successfulMsgTimer;
    private final Timer failedMsgTimer;

    public TbMsgPackCallback(UUID id, TenantId tenantId, TbMsgPackProcessingContext ctx) {
        this(id, tenantId, ctx, null, null);
    }

    public TbMsgPackCallback(UUID id, TenantId tenantId, TbMsgPackProcessingContext ctx, Timer successfulMsgTimer, Timer failedMsgTimer) {
        this.id = id;
        this.tenantId = tenantId;
        this.ctx = ctx;
        this.successfulMsgTimer = successfulMsgTimer;
        this.failedMsgTimer = failedMsgTimer;
        this.startMsgProcessing = System.currentTimeMillis();
    }

    public void onSuccess() {
        log.trace("[{}] ON SUCCESS", (Object)this.id);
        if (this.successfulMsgTimer != null) {
            this.successfulMsgTimer.record(System.currentTimeMillis() - this.startMsgProcessing, TimeUnit.MILLISECONDS);
        }
        this.ctx.onSuccess(this.id);
    }

    public void onRateLimit(RuleEngineException e) {
        log.debug("[{}] ON RATE LIMIT", (Object)this.id, (Object)e);
        if (this.failedMsgTimer != null) {
            this.failedMsgTimer.record(System.currentTimeMillis() - this.startMsgProcessing, TimeUnit.MILLISECONDS);
        }
        this.ctx.onSuccess(this.id);
    }

    public void onFailure(RuleEngineException e) {
        if (ExceptionUtil.lookupExceptionInCause((Throwable)e, (Class[])new Class[]{AbstractRateLimitException.class}) != null) {
            this.onRateLimit(e);
            return;
        }
        log.trace("[{}] ON FAILURE", (Object)this.id, (Object)e);
        if (this.failedMsgTimer != null) {
            this.failedMsgTimer.record(System.currentTimeMillis() - this.startMsgProcessing, TimeUnit.MILLISECONDS);
        }
        this.ctx.onFailure(this.tenantId, this.id, e);
    }

    public boolean isMsgValid() {
        return !this.ctx.isCanceled();
    }

    public void onProcessingStart(RuleNodeInfo ruleNodeInfo) {
        log.trace("[{}] ON PROCESSING START: {}", (Object)this.id, (Object)ruleNodeInfo);
        this.ctx.onProcessingStart(this.id, ruleNodeInfo);
    }

    public void onProcessingEnd(RuleNodeId ruleNodeId) {
        log.trace("[{}] ON PROCESSING END: {}", (Object)this.id, (Object)ruleNodeId);
        this.ctx.onProcessingEnd(this.id, ruleNodeId);
    }
}

