/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityActionEventMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldTelemetryMsg;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.queue.QueueConfig;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldPartitionChangeMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.dao.resource.TbResourceDataCache;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.PartitionedQueueConsumerManager;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;
import org.thingsboard.server.queue.util.TbPackCallback;
import org.thingsboard.server.queue.util.TbPackProcessingContext;
import org.thingsboard.server.queue.util.TbRuleEngineComponent;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.cf.CalculatedFieldStateService;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.queue.PendingMsgHolder;
import org.thingsboard.server.service.queue.TbCalculatedFieldConsumerService;
import org.thingsboard.server.service.queue.processing.AbstractPartitionBasedConsumerService;
import org.thingsboard.server.service.queue.processing.IdMsgPair;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;

@Service
@TbRuleEngineComponent
public class DefaultTbCalculatedFieldConsumerService
extends AbstractPartitionBasedConsumerService<TransportProtos.ToCalculatedFieldNotificationMsg>
implements TbCalculatedFieldConsumerService {
    @Value(value="${queue.calculated_fields.poll_interval:25}")
    private long pollInterval;
    @Value(value="${queue.calculated_fields.pack_processing_timeout:60000}")
    private long packProcessingTimeout;
    private final TbRuleEngineQueueFactory queueFactory;
    private final CalculatedFieldStateService stateService;

    public DefaultTbCalculatedFieldConsumerService(TbRuleEngineQueueFactory tbQueueFactory, ActorSystemContext actorContext, TbDeviceProfileCache deviceProfileCache, TbAssetProfileCache assetProfileCache, TbResourceDataCache tbResourceDataCache, TbTenantProfileCache tenantProfileCache, TbApiUsageStateService apiUsageStateService, PartitionService partitionService, ApplicationEventPublisher eventPublisher, JwtSettingsService jwtSettingsService, CalculatedFieldCache calculatedFieldCache, CalculatedFieldStateService stateService) {
        super(actorContext, tenantProfileCache, deviceProfileCache, assetProfileCache, tbResourceDataCache, calculatedFieldCache, apiUsageStateService, partitionService, eventPublisher, jwtSettingsService);
        this.queueFactory = tbQueueFactory;
        this.stateService = stateService;
    }

    protected void onStartUp() {
        QueueKey queueKey = new QueueKey(ServiceType.TB_RULE_ENGINE, "CalculatedFields");
        PartitionedQueueConsumerManager eventConsumer = PartitionedQueueConsumerManager.create().queueKey((Object)queueKey).topic(this.partitionService.getTopic(queueKey)).pollInterval(this.pollInterval).msgPackProcessor((arg_0, arg_1, arg_2, arg_3) -> this.processMsgs(arg_0, arg_1, arg_2, arg_3)).consumerCreator((queueConfig, tpi) -> this.queueFactory.createToCalculatedFieldMsgConsumer(tpi)).queueAdmin(this.queueFactory.getCalculatedFieldQueueAdmin()).consumerExecutor(this.consumersExecutor).scheduler(this.scheduler).taskExecutor(this.mgmtExecutor).build();
        this.stateService.init(eventConsumer);
    }

    @PreDestroy
    public void destroy() {
        super.destroy();
    }

    protected void startConsumers() {
        super.startConsumers();
    }

    protected void onPartitionChangeEvent(PartitionChangeEvent event) {
        try {
            event.getNewPartitions().forEach((queueKey, partitions) -> {
                if ("CalculatedFields".equals(queueKey.getQueueName())) {
                    this.stateService.restore(queueKey, partitions);
                }
            });
            this.actorContext.tell((TbActorMsg)new CalculatedFieldPartitionChangeMsg());
        }
        catch (Throwable t) {
            this.log.error("Failed to process partition change event: {}", (Object)event, (Object)t);
        }
    }

    private void processMsgs(List<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>> consumer, Object consumerKey, QueueConfig config) throws Exception {
        List<IdMsgPair> orderedMsgList = msgs.stream().map(msg -> new IdMsgPair(UUID.randomUUID(), msg)).toList();
        ConcurrentMap<UUID, TbProtoQueueMsg> pendingMap = orderedMsgList.stream().collect(Collectors.toConcurrentMap(IdMsgPair::getUuid, IdMsgPair::getMsg));
        CountDownLatch processingTimeoutLatch = new CountDownLatch(1);
        TbPackProcessingContext ctx = new TbPackProcessingContext(processingTimeoutLatch, pendingMap, new ConcurrentHashMap());
        PendingMsgHolder pendingMsgHolder = new PendingMsgHolder();
        Future<?> packSubmitFuture = this.consumersExecutor.submit(() -> orderedMsgList.forEach(element -> {
            UUID id = element.getUuid();
            TbProtoQueueMsg msg = element.getMsg();
            this.log.trace("[{}] Creating main callback for message: {}", (Object)id, (Object)msg.getValue());
            TbPackCallback callback = new TbPackCallback(id, ctx);
            try {
                TransportProtos.ToCalculatedFieldMsg toCfMsg = (TransportProtos.ToCalculatedFieldMsg)msg.getValue();
                pendingMsgHolder.setMsg((Object)toCfMsg);
                this.processMsg(toCfMsg, id, (TbCallback)callback);
            }
            catch (Throwable e) {
                this.log.warn("[{}] Failed to process message: {}", new Object[]{id, msg, e});
                callback.onFailure(e);
            }
        }));
        if (!processingTimeoutLatch.await(this.packProcessingTimeout, TimeUnit.MILLISECONDS)) {
            if (!packSubmitFuture.isDone()) {
                packSubmitFuture.cancel(true);
                this.log.info("Timeout to process message: {}", pendingMsgHolder.getMsg());
            }
            ctx.getAckMap().forEach((id, msg) -> this.log.warn("[{}] Timeout to process message: {}", id, (Object)msg.getValue()));
            ctx.getFailedMap().forEach((id, msg) -> this.log.warn("[{}] Failed to process message: {}", id, (Object)msg.getValue()));
        }
        consumer.commit();
    }

    private void processMsg(TransportProtos.ToCalculatedFieldMsg toCfMsg, UUID id, TbCallback callback) {
        if (toCfMsg.hasTelemetryMsg()) {
            this.log.trace("[{}] Forwarding regular telemetry message for processing {}", (Object)id, (Object)toCfMsg.getTelemetryMsg());
            this.forwardToActorSystem(toCfMsg.getTelemetryMsg(), callback);
        } else if (toCfMsg.hasLinkedTelemetryMsg()) {
            this.forwardToActorSystem(toCfMsg.getLinkedTelemetryMsg(), callback);
        } else if (toCfMsg.hasEventMsg()) {
            this.actorContext.tell((TbActorMsg)CalculatedFieldEntityActionEventMsg.fromProto((TransportProtos.EntityActionEventProto)toCfMsg.getEventMsg(), (TbCallback)callback));
        }
    }

    protected ServiceType getServiceType() {
        return ServiceType.TB_RULE_ENGINE;
    }

    protected String getPrefix() {
        return "tb-cf";
    }

    protected long getNotificationPollDuration() {
        return this.pollInterval;
    }

    protected long getNotificationPackProcessingTimeout() {
        return this.packProcessingTimeout;
    }

    protected int getMgmtThreadPoolSize() {
        return Math.max(Runtime.getRuntime().availableProcessors(), 4);
    }

    protected TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldNotificationMsg>> createNotificationsConsumer() {
        return this.queueFactory.createToCalculatedFieldNotificationMsgConsumer();
    }

    protected void handleNotification(UUID id, TbProtoQueueMsg<TransportProtos.ToCalculatedFieldNotificationMsg> msg, TbCallback callback) {
        TransportProtos.ToCalculatedFieldNotificationMsg toCfNotification = (TransportProtos.ToCalculatedFieldNotificationMsg)msg.getValue();
        if (toCfNotification.hasLinkedTelemetryMsg()) {
            this.forwardToActorSystem(toCfNotification.getLinkedTelemetryMsg(), callback);
        }
    }

    @EventListener
    public void handleComponentLifecycleEvent(ComponentLifecycleMsg event) {
        if (event.getEntityId().getEntityType() == EntityType.TENANT && event.getEvent() == ComponentLifecycleEvent.DELETED) {
            Set partitions = this.stateService.getPartitions();
            if (CollectionUtils.isEmpty((Collection)partitions)) {
                return;
            }
            this.stateService.delete(partitions.stream().filter(tpi -> tpi.getTenantId().isPresent() && ((TenantId)tpi.getTenantId().get()).equals((Object)event.getTenantId())).collect(Collectors.toSet()));
        }
    }

    private void forwardToActorSystem(TransportProtos.CalculatedFieldTelemetryMsgProto msg, TbCallback callback) {
        TenantId tenantId = this.toTenantId(msg.getTenantIdMSB(), msg.getTenantIdLSB());
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((String)msg.getEntityType(), (UUID)new UUID(msg.getEntityIdMSB(), msg.getEntityIdLSB()));
        this.actorContext.tell((TbActorMsg)new CalculatedFieldTelemetryMsg(tenantId, entityId, msg, callback));
    }

    private void forwardToActorSystem(TransportProtos.CalculatedFieldLinkedTelemetryMsgProto linkedMsg, TbCallback callback) {
        TransportProtos.CalculatedFieldTelemetryMsgProto msg = linkedMsg.getMsg();
        TenantId tenantId = this.toTenantId(msg.getTenantIdMSB(), msg.getTenantIdLSB());
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((String)msg.getEntityType(), (UUID)new UUID(msg.getEntityIdMSB(), msg.getEntityIdLSB()));
        this.actorContext.tell((TbActorMsg)new CalculatedFieldLinkedTelemetryMsg(tenantId, entityId, linkedMsg, callback));
    }

    private TenantId toTenantId(long tenantIdMSB, long tenantIdLSB) {
        return TenantId.fromUUID((UUID)new UUID(tenantIdMSB, tenantIdLSB));
    }

    protected void stopConsumers() {
        super.stopConsumers();
        this.stateService.stop();
    }
}

