/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.query;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.thingsboard.common.util.KvUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.query.AlarmCountQuery;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataPageLink;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.common.data.query.AvailableEntityKeys;
import org.thingsboard.server.common.data.query.ComplexFilterPredicate;
import org.thingsboard.server.common.data.query.DynamicValue;
import org.thingsboard.server.common.data.query.EntityCountQuery;
import org.thingsboard.server.common.data.query.EntityData;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.query.EntityDataSortOrder;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.FilterPredicateType;
import org.thingsboard.server.common.data.query.KeyFilter;
import org.thingsboard.server.common.data.query.KeyFilterPredicate;
import org.thingsboard.server.common.data.query.SimpleKeyFilterPredicate;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.query.DefaultEntityQueryService;
import org.thingsboard.server.service.query.EntityQueryService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
@TbCoreComponent
public class DefaultEntityQueryService
implements EntityQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEntityQueryService.class);
    private final EntityService entityService;
    @Autowired
    private AlarmService alarmService;
    @Value(value="${server.ws.max_entities_per_alarm_subscription:1000}")
    private int maxEntitiesPerAlarmSubscription;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutor;
    @Autowired
    private TimeseriesService timeseriesService;
    @Autowired
    private AttributesService attributesService;

    public DefaultEntityQueryService(EntityService entityService) {
        this.entityService = entityService;
    }

    public long countEntitiesByQuery(SecurityUser securityUser, EntityCountQuery query) {
        return this.entityService.countEntitiesByQuery(securityUser.getTenantId(), securityUser.getCustomerId(), securityUser.getUserPermissions(), query);
    }

    public PageData<EntityData> findEntityDataByQuery(SecurityUser securityUser, EntityDataQuery query) {
        if (query.getKeyFilters() != null) {
            this.resolveDynamicValuesInPredicates(query.getKeyFilters().stream().map(KeyFilter::getPredicate).collect(Collectors.toList()), securityUser);
        }
        return this.entityService.findEntityDataByQuery(securityUser.getTenantId(), securityUser.getCustomerId(), securityUser.getUserPermissions(), query);
    }

    private void resolveDynamicValuesInPredicates(List<KeyFilterPredicate> predicates, SecurityUser user) {
        predicates.forEach(predicate -> {
            if (predicate.getType() == FilterPredicateType.COMPLEX) {
                this.resolveDynamicValuesInPredicates(((ComplexFilterPredicate)predicate).getPredicates(), user);
            } else {
                this.setResolvedValue(user, (SimpleKeyFilterPredicate)predicate);
            }
        });
    }

    private void setResolvedValue(SecurityUser user, SimpleKeyFilterPredicate<?> predicate) {
        DynamicValue dynamicValue = predicate.getValue().getDynamicValue();
        if (dynamicValue != null && dynamicValue.getResolvedValue() == null) {
            this.resolveDynamicValue(dynamicValue, user, predicate.getType());
        }
    }

    private <T> void resolveDynamicValue(DynamicValue<T> dynamicValue, SecurityUser user, FilterPredicateType predicateType) {
        TenantId entityId = switch (1.$SwitchMap$org$thingsboard$server$common$data$query$DynamicValueSourceType[dynamicValue.getSourceType().ordinal()]) {
            case 1 -> user.getTenantId();
            case 2 -> user.getCustomerId();
            case 3 -> user.getId();
            default -> throw new RuntimeException("Not supported operation for source type: {" + String.valueOf(dynamicValue.getSourceType()) + "}");
        };
        try {
            Optional valueOpt = (Optional)this.attributesService.find(user.getTenantId(), (EntityId)entityId, AttributeScope.SERVER_SCOPE, dynamicValue.getSourceAttribute()).get();
            if (valueOpt.isPresent()) {
                AttributeKvEntry entry = (AttributeKvEntry)valueOpt.get();
                Object resolved = null;
                switch (1.$SwitchMap$org$thingsboard$server$common$data$query$FilterPredicateType[predicateType.ordinal()]) {
                    case 1: {
                        resolved = KvUtil.getStringValue((KvEntry)entry);
                        break;
                    }
                    case 2: {
                        resolved = KvUtil.getDoubleValue((KvEntry)entry);
                        break;
                    }
                    case 3: {
                        resolved = KvUtil.getBoolValue((KvEntry)entry);
                        break;
                    }
                }
                dynamicValue.setResolvedValue(resolved);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public PageData<AlarmData> findAlarmDataByQuery(SecurityUser securityUser, AlarmDataQuery query) {
        EntityDataQuery entityDataQuery = this.buildEntityDataQuery(query);
        PageData entities = this.entityService.findEntityDataByQuery(securityUser.getTenantId(), securityUser.getCustomerId(), securityUser.getUserPermissions(), entityDataQuery);
        if (entities.getTotalElements() > 0L) {
            LinkedHashMap<EntityId, EntityData> entitiesMap = new LinkedHashMap<EntityId, EntityData>();
            for (EntityData entityData : entities.getData()) {
                entitiesMap.put(entityData.getEntityId(), entityData);
            }
            PageData alarms = this.alarmService.findAlarmDataByQueryForEntities(securityUser.getTenantId(), securityUser.getUserPermissions(), query, entitiesMap.keySet());
            for (AlarmData alarmData : alarms.getData()) {
                EntityData entityData;
                EntityId entityId = alarmData.getEntityId();
                if (entityId == null || (entityData = (EntityData)entitiesMap.get(entityId)) == null) continue;
                alarmData.getLatest().putAll(entityData.getLatest());
            }
            return alarms;
        }
        return new PageData();
    }

    public long countAlarmsByQuery(SecurityUser securityUser, AlarmCountQuery query) {
        if (query.getEntityFilter() != null) {
            EntityDataQuery entityDataQuery = this.buildEntityDataQuery(query);
            PageData entities = this.entityService.findEntityDataByQuery(securityUser.getTenantId(), securityUser.getCustomerId(), securityUser.getUserPermissions(), entityDataQuery);
            if (entities.getTotalElements() > 0L) {
                List<EntityId> entityIds = entities.getData().stream().map(EntityData::getEntityId).toList();
                return this.alarmService.countAlarmsByQuery(securityUser.getTenantId(), securityUser.getCustomerId(), securityUser.getUserPermissions(), query, entityIds);
            }
            return 0L;
        }
        return this.alarmService.countAlarmsByQuery(securityUser.getTenantId(), securityUser.getCustomerId(), securityUser.getUserPermissions(), query);
    }

    private EntityDataQuery buildEntityDataQuery(AlarmCountQuery query) {
        EntityDataPageLink edpl = new EntityDataPageLink(this.maxEntitiesPerAlarmSubscription, 0, null, new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime")));
        return new EntityDataQuery(query.getEntityFilter(), edpl, null, null, query.getKeyFilters());
    }

    private EntityDataQuery buildEntityDataQuery(AlarmDataQuery query) {
        EntityDataSortOrder sortOrder = ((AlarmDataPageLink)query.getPageLink()).getSortOrder();
        EntityDataSortOrder entitiesSortOrder = sortOrder == null || sortOrder.getKey().getType().equals((Object)EntityKeyType.ALARM_FIELD) ? new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime")) : sortOrder;
        EntityDataPageLink edpl = new EntityDataPageLink(this.maxEntitiesPerAlarmSubscription, 0, null, entitiesSortOrder);
        return new EntityDataQuery(query.getEntityFilter(), edpl, query.getEntityFields(), query.getLatestValues(), query.getKeyFilters());
    }

    public ListenableFuture<AvailableEntityKeys> getKeysByQuery(SecurityUser securityUser, TenantId tenantId, EntityDataQuery query, boolean isTimeseries, boolean isAttributes, AttributeScope scope) {
        ListenableFuture attributesKeysFuture;
        if (!isAttributes && !isTimeseries) {
            return Futures.immediateFuture((Object)AvailableEntityKeys.none());
        }
        List<EntityId> ids = this.findEntityDataByQuery(securityUser, query).getData().stream().map(EntityData::getEntityId).toList();
        if (ids.isEmpty()) {
            return Futures.immediateFuture((Object)AvailableEntityKeys.none());
        }
        Set types = ids.stream().map(EntityId::getEntityType).collect(Collectors.toSet());
        ListenableFuture timeseriesKeysFuture = isTimeseries ? this.timeseriesService.findAllKeysByEntityIdsAsync(tenantId, ids) : Futures.immediateFuture(Collections.emptyList());
        if (isAttributes) {
            Map<EntityType, List<EntityId>> typesMap = ids.stream().collect(Collectors.groupingBy(EntityId::getEntityType));
            ArrayList futures = new ArrayList(typesMap.size());
            typesMap.forEach((type, entityIds) -> futures.add(this.dbCallbackExecutor.submit(() -> this.attributesService.findAllKeysByEntityIds(tenantId, entityIds, scope))));
            attributesKeysFuture = Futures.transform((ListenableFuture)Futures.allAsList(futures), lists -> {
                if (CollectionUtils.isEmpty((Collection)lists)) {
                    return Collections.emptyList();
                }
                return lists.stream().flatMap(Collection::stream).distinct().sorted().toList();
            }, (Executor)this.dbCallbackExecutor);
        } else {
            attributesKeysFuture = Futures.immediateFuture(Collections.emptyList());
        }
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{timeseriesKeysFuture, attributesKeysFuture}).call(() -> {
            try {
                return new AvailableEntityKeys(types, (List)Futures.getDone((Future)timeseriesKeysFuture), (List)Futures.getDone((Future)attributesKeysFuture));
            }
            catch (ExecutionException e) {
                throw new ThingsboardException(e.getCause(), ThingsboardErrorCode.DATABASE);
            }
        }, (Executor)this.dbCallbackExecutor);
    }
}

