/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.partition;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@Service
public class TbCoreStartupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCoreStartupService.class);
    private final PartitionService partitionService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbClusterService clusterService;

    @AfterStartUp(order=8)
    public void onApplicationEvent(ApplicationReadyEvent event) {
        List myPartitions = this.partitionService.getMyPartitions(new QueueKey(ServiceType.TB_CORE));
        if (myPartitions != null && !myPartitions.isEmpty()) {
            TransportProtos.ToCoreNotificationMsg toCoreMsg = TransportProtos.ToCoreNotificationMsg.newBuilder().setCoreStartupMsg(TransportProtos.CoreStartupMsg.newBuilder().setServiceId(this.serviceInfoProvider.getServiceId()).addAllPartitions((Iterable)myPartitions).build()).build();
            this.clusterService.broadcastToCore(toCoreMsg);
        }
    }

    @ConstructorProperties(value={"partitionService", "serviceInfoProvider", "clusterService"})
    @Generated
    public TbCoreStartupService(PartitionService partitionService, TbServiceInfoProvider serviceInfoProvider, TbClusterService clusterService) {
        this.partitionService = partitionService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.clusterService = clusterService;
    }
}

