/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.info.RateLimitsNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.RateLimitsTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.notification.rule.trigger.config.RateLimitsNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class RateLimitsTriggerProcessor
implements NotificationRuleTriggerProcessor<RateLimitsTrigger, RateLimitsNotificationRuleTriggerConfig> {
    private final TenantService tenantService;
    private final EntityService entityService;

    public boolean matchesFilter(RateLimitsTrigger trigger, RateLimitsNotificationRuleTriggerConfig triggerConfig) {
        return trigger.getLimitLevel() != null && trigger.getApi().getLabel() != null && CollectionsUtil.emptyOrContains((Collection)triggerConfig.getApis(), (Object)trigger.getApi());
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(RateLimitsTrigger trigger) {
        EntityId limitLevel = trigger.getLimitLevel();
        String tenantName = this.tenantService.findTenantById(trigger.getTenantId()).getName();
        String limitLevelEntityName = null;
        if (limitLevel instanceof TenantId) {
            limitLevelEntityName = tenantName;
        } else if (limitLevel != null) {
            limitLevelEntityName = Optional.ofNullable(trigger.getLimitLevelEntityName()).orElseGet(() -> this.entityService.fetchEntityName(trigger.getTenantId(), limitLevel).orElse(null));
        }
        return RateLimitsNotificationInfo.builder().tenantId(trigger.getTenantId()).tenantName(tenantName).api(trigger.getApi()).limitLevel(limitLevel).limitLevelEntityName(limitLevelEntityName).build();
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.RATE_LIMITS;
    }

    @ConstructorProperties(value={"tenantService", "entityService"})
    @Generated
    public RateLimitsTriggerProcessor(TenantService tenantService, EntityService entityService) {
        this.tenantService = tenantService;
        this.entityService = entityService;
    }
}

