/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.notification.info.IntegrationLifecycleEventNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.IntegrationLifecycleEventTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.IntegrationLifecycleEventNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class IntegrationLifecycleEventTriggerProcessor
implements NotificationRuleTriggerProcessor<IntegrationLifecycleEventTrigger, IntegrationLifecycleEventNotificationRuleTriggerConfig> {
    public boolean matchesFilter(IntegrationLifecycleEventTrigger trigger, IntegrationLifecycleEventNotificationRuleTriggerConfig triggerConfig) {
        return !(!CollectionUtils.isEmpty((Collection)triggerConfig.getIntegrationTypes()) && !triggerConfig.getIntegrationTypes().contains(trigger.getIntegrationType()) || !CollectionUtils.isEmpty((Collection)triggerConfig.getIntegrations()) && !triggerConfig.getIntegrations().contains(trigger.getIntegrationId().getId()) || !CollectionUtils.isEmpty((Collection)triggerConfig.getNotifyOn()) && !triggerConfig.getNotifyOn().contains(trigger.getEvent()) || triggerConfig.isOnlyOnError() && trigger.getError() == null);
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(IntegrationLifecycleEventTrigger trigger) {
        return IntegrationLifecycleEventNotificationInfo.builder().integrationId(trigger.getIntegrationId()).integrationType(trigger.getIntegrationType().name()).integrationName(trigger.getIntegrationName()).action(trigger.getEvent() == ComponentLifecycleEvent.STARTED ? "start" : (trigger.getEvent() == ComponentLifecycleEvent.UPDATED ? "update" : (trigger.getEvent() == ComponentLifecycleEvent.STOPPED ? "stop" : null))).eventType(trigger.getEvent()).error(trigger.getError() != null ? StringUtils.abbreviate((String)trigger.getError().getMessage(), (int)50) : null).build();
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.INTEGRATION_LIFECYCLE_EVENT;
    }

    @Generated
    public IntegrationLifecycleEventTriggerProcessor() {
    }
}

