/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.notification.info.EdgeConnectionNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.EdgeConnectionTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.EdgeConnectionNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class EdgeConnectionTriggerProcessor
implements NotificationRuleTriggerProcessor<EdgeConnectionTrigger, EdgeConnectionNotificationRuleTriggerConfig> {
    public boolean matchesFilter(EdgeConnectionTrigger trigger, EdgeConnectionNotificationRuleTriggerConfig triggerConfig) {
        EdgeConnectionNotificationRuleTriggerConfig.EdgeConnectivityEvent event;
        EdgeConnectionNotificationRuleTriggerConfig.EdgeConnectivityEvent edgeConnectivityEvent = event = trigger.isConnected() ? EdgeConnectionNotificationRuleTriggerConfig.EdgeConnectivityEvent.CONNECTED : EdgeConnectionNotificationRuleTriggerConfig.EdgeConnectivityEvent.DISCONNECTED;
        if (CollectionUtils.isEmpty((Collection)triggerConfig.getNotifyOn()) || !triggerConfig.getNotifyOn().contains(event)) {
            return false;
        }
        if (CollectionUtils.isNotEmpty((Collection)triggerConfig.getEdges())) {
            return triggerConfig.getEdges().contains(trigger.getEdgeId().getId());
        }
        return true;
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(EdgeConnectionTrigger trigger) {
        return EdgeConnectionNotificationInfo.builder().eventType(trigger.isConnected() ? "connected" : "disconnected").tenantId(trigger.getTenantId()).customerId(trigger.getCustomerId()).edgeId(trigger.getEdgeId()).edgeName(trigger.getEdgeName()).build();
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.EDGE_CONNECTION;
    }

    @Generated
    public EdgeConnectionTriggerProcessor() {
    }
}

