/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.info.DeviceActivityNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.DeviceActivityTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.DeviceActivityNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;

@Service
public class DeviceActivityTriggerProcessor
implements NotificationRuleTriggerProcessor<DeviceActivityTrigger, DeviceActivityNotificationRuleTriggerConfig> {
    private final TbDeviceProfileCache deviceProfileCache;

    public boolean matchesFilter(DeviceActivityTrigger trigger, DeviceActivityNotificationRuleTriggerConfig triggerConfig) {
        DeviceActivityNotificationRuleTriggerConfig.DeviceEvent event;
        DeviceActivityNotificationRuleTriggerConfig.DeviceEvent deviceEvent = event = trigger.isActive() ? DeviceActivityNotificationRuleTriggerConfig.DeviceEvent.ACTIVE : DeviceActivityNotificationRuleTriggerConfig.DeviceEvent.INACTIVE;
        if (!triggerConfig.getNotifyOn().contains(event)) {
            return false;
        }
        DeviceId deviceId = trigger.getDeviceId();
        if (CollectionUtils.isNotEmpty((Collection)triggerConfig.getDevices())) {
            return triggerConfig.getDevices().contains(deviceId.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)triggerConfig.getDeviceProfiles())) {
            DeviceProfile deviceProfile = this.deviceProfileCache.get(TenantId.SYS_TENANT_ID, deviceId);
            return deviceProfile != null && triggerConfig.getDeviceProfiles().contains(deviceProfile.getUuidId());
        }
        return true;
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(DeviceActivityTrigger trigger) {
        return DeviceActivityNotificationInfo.builder().eventType(trigger.isActive() ? "active" : "inactive").deviceId(trigger.getDeviceId().getId()).deviceName(trigger.getDeviceName()).deviceType(trigger.getDeviceType()).deviceLabel(trigger.getDeviceLabel()).deviceCustomerId(trigger.getCustomerId()).build();
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.DEVICE_ACTIVITY;
    }

    @ConstructorProperties(value={"deviceProfileCache"})
    @Generated
    public DeviceActivityTriggerProcessor(TbDeviceProfileCache deviceProfileCache) {
        this.deviceProfileCache = deviceProfileCache;
    }
}

